"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ManageMLJobComponent = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _reactRedux = require("react-redux");
var _public = require("@kbn/kibana-react-plugin/public");
var _uptime_alerts = require("../../../../../common/constants/uptime_alerts");
var _selectors = require("../../../state/selectors");
var _contexts = require("../../../contexts");
var labels = _interopRequireWildcard(require("./translations"));
var _ml_job_link = require("./ml_job_link");
var _hooks = require("../../../hooks");
var _actions = require("../../../state/actions");
var _use_anomaly_alert = require("./use_anomaly_alert");
var _confirm_alert_delete = require("./confirm_alert_delete");
var _alerts = require("../../../state/alerts/alerts");
var _uptime_edit_alert_flyout = require("../../common/alerts/uptime_edit_alert_flyout");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ManageMLJobComponent = ({
  hasMLJob,
  onEnableJob,
  onJobDelete
}) => {
  var _core$services$applic, _core$services$applic2, _core$services$applic3;
  const core = (0, _public.useKibana)();
  const [isPopOverOpen, setIsPopOverOpen] = (0, _react.useState)(false);
  const [isFlyoutOpen, setIsFlyoutOpen] = (0, _react.useState)(false);
  const {
    basePath
  } = (0, _react.useContext)(_contexts.UptimeSettingsContext);
  const canDeleteMLJob = (0, _reactRedux.useSelector)(_selectors.canDeleteMLJobSelector);
  const isMLJobCreating = (0, _reactRedux.useSelector)(_selectors.isMLJobCreatingSelector);
  const isAlertDeleting = (0, _reactRedux.useSelector)(_alerts.isAnomalyAlertDeleting);
  const {
    loading: isMLJobLoading
  } = (0, _reactRedux.useSelector)(_selectors.hasMLJobSelector);
  const {
    loading: isCapbilityLoading
  } = (0, _reactRedux.useSelector)(_selectors.mlCapabilitiesSelector);
  const {
    dateRangeStart,
    dateRangeEnd
  } = (0, _hooks.useGetUrlParams)();
  const monitorId = (0, _hooks.useMonitorId)();
  const dispatch = (0, _reactRedux.useDispatch)();
  const anomalyAlert = (0, _use_anomaly_alert.useAnomalyAlert)();
  const [isConfirmAlertDeleteOpen, setIsConfirmAlertDeleteOpen] = (0, _react.useState)(false);
  const deleteAnomalyAlert = () => dispatch(_alerts.deleteAnomalyAlertAction.get({
    alertId: anomalyAlert === null || anomalyAlert === void 0 ? void 0 : anomalyAlert.id
  }));
  const showLoading = isMLJobCreating || isMLJobLoading || isAlertDeleting || isCapbilityLoading;
  const btnText = hasMLJob ? labels.ANOMALY_DETECTION : labels.ENABLE_ANOMALY_DETECTION;
  const button = /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": hasMLJob ? 'uptimeManageMLJobBtn' : 'uptimeEnableAnomalyBtn',
    onClick: hasMLJob ? () => setIsPopOverOpen(!isPopOverOpen) : onEnableJob,
    disabled: hasMLJob && !canDeleteMLJob,
    isLoading: showLoading,
    size: "s",
    "aria-label": labels.ENABLE_MANAGE_JOB
  }, showLoading ? '' : btnText);
  const hasUptimeWrite = (_core$services$applic = (_core$services$applic2 = core.services.application) === null || _core$services$applic2 === void 0 ? void 0 : (_core$services$applic3 = _core$services$applic2.capabilities.uptime) === null || _core$services$applic3 === void 0 ? void 0 : _core$services$applic3.save) !== null && _core$services$applic !== void 0 ? _core$services$applic : false;
  const panels = [{
    id: 0,
    title: labels.MANAGE_ANOMALY_DETECTION,
    items: [{
      name: labels.EXPLORE_IN_ML_APP,
      icon: /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
        type: "dataVisualizer",
        size: "m"
      }),
      href: (0, _ml_job_link.getMLJobLinkHref)({
        basePath,
        monitorId,
        dateRange: {
          from: dateRangeStart,
          to: dateRangeEnd
        }
      })
    }, ...(anomalyAlert ? [{
      name: 'Anomaly alert',
      icon: 'bell',
      'data-test-subj': 'uptimeManageAnomalyAlertBtn',
      panel: 1
    }] : [{
      name: labels.ENABLE_ANOMALY_ALERT,
      'data-test-subj': 'uptimeEnableAnomalyAlertBtn',
      icon: 'bell',
      disabled: !hasUptimeWrite,
      toolTipContent: !hasUptimeWrite ? labels.ENABLE_ANOMALY_NO_PERMISSIONS_TOOLTIP : null,
      onClick: () => {
        dispatch((0, _actions.setAlertFlyoutType)(_uptime_alerts.CLIENT_ALERT_TYPES.DURATION_ANOMALY));
        dispatch((0, _actions.setAlertFlyoutVisible)(true));
        setIsPopOverOpen(false);
      }
    }]), {
      name: labels.DISABLE_ANOMALY_DETECTION,
      'data-test-subj': 'uptimeDeleteMLJobBtn',
      icon: /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
        type: "trash",
        size: "m"
      }),
      onClick: () => {
        setIsPopOverOpen(false);
        onJobDelete();
      }
    }]
  }, {
    id: 1,
    title: 'Anomaly alert',
    items: [{
      name: 'Edit',
      'data-test-subj': 'uptimeEditAnomalyAlertBtn',
      onClick: () => {
        setIsFlyoutOpen(true);
        setIsPopOverOpen(false);
      }
    }, {
      name: 'Disable',
      'data-test-subj': 'uptimeDisableAnomalyAlertBtn',
      onClick: () => {
        setIsConfirmAlertDeleteOpen(true);
      }
    }]
  }];
  const onCloseFlyout = (0, _react.useCallback)(() => {
    setIsFlyoutOpen(false);
    dispatch(_alerts.getAnomalyAlertAction.get({
      monitorId
    }));
  }, [dispatch, monitorId]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    button: button,
    isOpen: isPopOverOpen,
    closePopover: () => setIsPopOverOpen(false),
    panelPaddingSize: "none"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenu, {
    initialPanelId: 0,
    panels: panels,
    "data-test-subj": "uptimeManageMLContextMenu"
  })), isConfirmAlertDeleteOpen && /*#__PURE__*/_react.default.createElement(_confirm_alert_delete.ConfirmAlertDeletion, {
    onConfirm: () => {
      deleteAnomalyAlert();
      setIsConfirmAlertDeleteOpen(false);
      setIsPopOverOpen(false);
    },
    onCancel: () => {
      setIsConfirmAlertDeleteOpen(false);
    }
  }), isFlyoutOpen && /*#__PURE__*/_react.default.createElement(_uptime_edit_alert_flyout.UptimeEditAlertFlyoutComponent, {
    initialAlert: anomalyAlert,
    alertFlyoutVisible: isFlyoutOpen,
    setAlertFlyoutVisibility: onCloseFlyout
  }));
};
exports.ManageMLJobComponent = ManageMLJobComponent;