"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CertStatus = void 0;
var _react = _interopRequireDefault(require("react"));
var _moment = _interopRequireDefault(require("moment"));
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _reactRedux = require("react-redux");
var _hooks = require("../../hooks");
var labels = _interopRequireWildcard(require("./translations"));
var _constants = require("../../../../common/constants");
var _selectors = require("../../state/selectors");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DateText = (0, _styledComponents.default)(_eui.EuiText)`
  display: inline-block;
  margin-left: 5px;
`;
const CertStatus = ({
  cert
}) => {
  const certStatus = (0, _hooks.useCertStatus)(cert === null || cert === void 0 ? void 0 : cert.not_after, cert === null || cert === void 0 ? void 0 : cert.not_before);
  const dss = (0, _reactRedux.useSelector)(_selectors.selectDynamicSettings);
  const relativeDate = (0, _moment.default)(cert === null || cert === void 0 ? void 0 : cert.not_after).fromNow();
  if (certStatus === _constants.CERT_STATUS.EXPIRING_SOON) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiHealth, {
      color: "warning"
    }, /*#__PURE__*/_react.default.createElement("span", null, labels.EXPIRES_SOON, '  ', /*#__PURE__*/_react.default.createElement(DateText, {
      color: "subdued",
      size: "xs"
    }, relativeDate)));
  }
  if (certStatus === _constants.CERT_STATUS.EXPIRED) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiHealth, {
      color: "danger"
    }, /*#__PURE__*/_react.default.createElement("span", null, labels.EXPIRED, '  ', /*#__PURE__*/_react.default.createElement(DateText, {
      color: "subdued",
      size: "xs"
    }, relativeDate)));
  }
  if (certStatus === _constants.CERT_STATUS.TOO_OLD) {
    var _dss$settings;
    const ageThreshold = (_dss$settings = dss.settings) === null || _dss$settings === void 0 ? void 0 : _dss$settings.certAgeThreshold;
    const oldRelativeDate = (0, _moment.default)(cert === null || cert === void 0 ? void 0 : cert.not_before).add(ageThreshold, 'days').fromNow();
    return /*#__PURE__*/_react.default.createElement(_eui.EuiHealth, {
      color: "danger"
    }, /*#__PURE__*/_react.default.createElement("span", null, labels.TOO_OLD, /*#__PURE__*/_react.default.createElement(DateText, {
      color: "subdued",
      size: "xs"
    }, oldRelativeDate)));
  }
  const okRelativeDate = (0, _moment.default)(cert === null || cert === void 0 ? void 0 : cert.not_after).fromNow(true);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiHealth, {
    color: "success"
  }, /*#__PURE__*/_react.default.createElement("span", null, labels.OK, '  ', /*#__PURE__*/_react.default.createElement(DateText, {
    color: "subdued",
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.uptime.certs.status.ok.label",
    defaultMessage: " for {okRelativeDate}",
    description: "Denotes an amount of time for which a cert is valid. Example: \"OK for 2 days\"",
    values: {
      okRelativeDate
    }
  }))));
};
exports.CertStatus = CertStatus;