"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.idForWarning = exports.WarningModalStep = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _types = require("../../../../../../../../../common/types");
var _app_context = require("../../../../../../../app_context");
var _warning_step_checkbox = require("./warning_step_checkbox");
var _callouts = require("../callouts");
var _nodes_low_disk_space = require("../../../../../common/nodes_low_disk_space");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ML_ANOMALIES_PREFIX = '.ml-anomalies-';
const warningToComponentMap = {
  indexSetting: _warning_step_checkbox.DeprecatedSettingWarningCheckbox,
  replaceIndexWithAlias: _warning_step_checkbox.ReplaceIndexWithAliasWarningCheckbox,
  makeIndexReadonly: _warning_step_checkbox.MakeIndexReadonlyWarningCheckbox
};
const idForWarning = id => `reindexWarning-${id}`;
exports.idForWarning = idForWarning;
const WarningModalStep = props => {
  return props.flow === 'readonly' ? /*#__PURE__*/_react.default.createElement(WarningReadOnlyModalStep, props) : /*#__PURE__*/_react.default.createElement(WarningUnfreezeModalStep, props);
};
exports.WarningModalStep = WarningModalStep;
const WarningUnfreezeModalStep = ({
  confirm,
  reindexState,
  closeModal
}) => {
  const {
    services: {
      api
    }
  } = (0, _app_context.useAppContext)();
  const {
    status: reindexStatus,
    meta: {
      indexName
    }
  } = reindexState;
  const {
    data: nodes
  } = api.useLoadNodeDiskSpace();
  const hasFetchFailed = reindexStatus === _types.ReindexStatus.fetchFailed;
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeader, null, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeaderTitle, {
    "data-test-subj": "updateIndexModalTitle",
    size: "m"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.upgradeAssistant.esDeprecations.indices.indexModal.warningsStep.unfreeze.title",
    defaultMessage: "Unfreeze index"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiModalBody, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.upgradeAssistant.esDeprecations.indices.indexModal.warningsStep.unfreeze.calloutDetail",
    defaultMessage: "Unfreeze {indexName}. This action will also set it to read-only. This ensures that the index will remain compatible with the next major version.",
    values: {
      indexName: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, null, indexName)
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), hasFetchFailed && /*#__PURE__*/_react.default.createElement(_callouts.FetchFailedCallOut, {
    errorMessage: reindexState.errorMessage
  }), nodes && nodes.length > 0 && /*#__PURE__*/_react.default.createElement(_nodes_low_disk_space.NodesLowSpaceCallOut, {
    nodes: nodes
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiModalFooter, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "flexEnd",
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    onClick: closeModal,
    color: "primary",
    "data-test-subj": "startIndexUnfreezeCancelButton"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.upgradeAssistant.esDeprecations.indices.indexModal.warningsStep.readonly.cancelButtonLabel",
    defaultMessage: "Cancel"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    fill: true,
    color: "primary",
    onClick: confirm,
    "data-test-subj": "startIndexUnfreezeButton"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.upgradeAssistant.esDeprecations.indices.indexModal.warningsStep.readonly.continueButtonLabel",
    "data-test-subj": "startIndexUnfreezeButton",
    defaultMessage: "Unfreeze index"
  })))));
};
const WarningReadOnlyModalStep = ({
  confirm,
  meta,
  warnings,
  deprecation,
  reindexState,
  closeModal
}) => {
  var _correctiveAction$tra;
  const {
    services: {
      api,
      core: {
        docLinks
      }
    }
  } = (0, _app_context.useAppContext)();
  const {
    links
  } = docLinks;
  const [checkedIds, setCheckedIds] = (0, _react.useState)(warnings.reduce((initialCheckedIds, warning, index) => {
    initialCheckedIds[idForWarning(index)] = false;
    return initialCheckedIds;
  }, {}));
  const {
    meta: {
      indexName
    },
    status: reindexStatus
  } = reindexState;
  const {
    data: nodes
  } = api.useLoadNodeDiskSpace();
  const hasFetchFailed = reindexStatus === _types.ReindexStatus.fetchFailed;
  const correctiveAction = deprecation === null || deprecation === void 0 ? void 0 : deprecation.correctiveAction;
  const isESTransformTarget = !!(correctiveAction !== null && correctiveAction !== void 0 && (_correctiveAction$tra = correctiveAction.transformIds) !== null && _correctiveAction$tra !== void 0 && _correctiveAction$tra.length);
  const isMLAnomalyIndex = Boolean(indexName === null || indexName === void 0 ? void 0 : indexName.startsWith(ML_ANOMALIES_PREFIX));

  // Do not allow to proceed until all checkboxes are checked.
  const blockAdvance = Object.values(checkedIds).filter(v => v).length < warnings.length;
  const onChange = e => {
    const optionId = e.target.id;
    setCheckedIds(prev => ({
      ...prev,
      ...{
        [optionId]: !checkedIds[optionId]
      }
    }));
  };
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeader, null, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeaderTitle, {
    "data-test-subj": "updateIndexModalTitle",
    size: "m"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.upgradeAssistant.esDeprecations.indices.indexModal.warningsStep.readonly.title",
    defaultMessage: "Set index to read-only"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiModalBody, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.upgradeAssistant.esDeprecations.indices.indexModal.warningsStep.readonly.description",
    defaultMessage: "Old indices can maintain compatibility with the next major version if they are turned into read-only mode. If you no longer need to update documents in this index (or add new ones), it\u2019s recommended to set it to read-only index."
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), hasFetchFailed && /*#__PURE__*/_react.default.createElement(_callouts.FetchFailedCallOut, {
    errorMessage: reindexState.errorMessage
  }), nodes && nodes.length > 0 && /*#__PURE__*/_react.default.createElement(_nodes_low_disk_space.NodesLowSpaceCallOut, {
    nodes: nodes
  }), meta.isFollowerIndex && /*#__PURE__*/_react.default.createElement(_callouts.FollowerIndexCallout, null), isESTransformTarget && /*#__PURE__*/_react.default.createElement(_callouts.ESTransformsTargetCallout, {
    deprecation: deprecation
  }), isMLAnomalyIndex && /*#__PURE__*/_react.default.createElement(_callouts.MlAnomalyCallout, null), warnings.length > 0 && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.upgradeAssistant.esDeprecations.indices.indexModal.warningsStep.readonly.calloutTitle",
      defaultMessage: "Enable compatibility by setting this index to read-only"
    }),
    color: "warning",
    iconType: "warning"
  }, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.upgradeAssistant.esDeprecations.indices.indexModal.warningsStep.readonly.calloutDetail",
    defaultMessage: "Note that any attempts to insert new documents or update existing ones will fail. You can choose to reindex after upgrading if needed, to convert the index into a writable one."
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement("h3", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.upgradeAssistant.esDeprecations.indices.indexModal.warningsStep.acceptChangesTitle",
    defaultMessage: "Accept changes"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), warnings.map((warning, index) => {
    const WarningCheckbox = warningToComponentMap[warning.warningType];
    return /*#__PURE__*/_react.default.createElement(WarningCheckbox, {
      key: idForWarning(index),
      isChecked: checkedIds[idForWarning(index)],
      onChange: onChange,
      docLinks: links,
      id: idForWarning(index),
      meta: {
        ...meta,
        ...warning.meta
      }
    });
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiModalFooter, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "flexEnd",
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    onClick: closeModal,
    color: "primary",
    "data-test-subj": "warningModalCancelButton"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.upgradeAssistant.esDeprecations.indices.indexModal.warningsStep.readonly.cancelButtonLabel",
    defaultMessage: "Cancel"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    fill: true,
    color: "primary",
    onClick: confirm,
    disabled: blockAdvance,
    "data-test-subj": "startIndexReadonlyButton"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.upgradeAssistant.esDeprecations.indices.indexModal.warningsStep.readonly.continueButtonLabel",
    "data-test-subj": "startIndexReadonlyButton",
    defaultMessage: "Set to read-only"
  })))));
};