"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.IndexModal = void 0;
var _react = _interopRequireWildcard(require("react"));
var _analytics = require("@kbn/analytics");
var _eui = require("@elastic/eui");
var _ui_metric = require("../../../../../lib/ui_metric");
var _initializing_step = require("../../../common/initializing_step");
var _update_step = require("./steps/update/update_step");
var _warning_step_modal = require("./steps/warning/warning_step_modal");
var _delete_step_modal = require("../../../common/delete_step_modal");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const IndexModal = ({
  reindexState,
  updateIndexState,
  updateIndex,
  closeModal,
  deprecation,
  selectedResolutionType
}) => {
  const {
    status: reindexStatus,
    errorMessage
  } = reindexState;
  const {
    status: updateIndexStatus,
    updateAction
  } = updateIndexState;
  const {
    correctiveAction
  } = deprecation;
  const [modalStep, setModalStep] = (0, _react.useState)('initializing');
  const onMakeReadonly = (0, _react.useCallback)(async () => {
    _ui_metric.uiMetricService.trackUiMetric(_analytics.METRIC_TYPE.CLICK, _ui_metric.UIM_REINDEX_READONLY_CLICK);
    await updateIndex('readonly');
  }, [updateIndex]);
  const onMakeReadonlyRetry = (0, _react.useCallback)(async () => {
    _ui_metric.uiMetricService.trackUiMetric(_analytics.METRIC_TYPE.CLICK, _ui_metric.UIM_REINDEX_READONLY_RETRY_CLICK);
    await updateIndex('readonly');
  }, [updateIndex]);
  const onUnfreeze = (0, _react.useCallback)(async () => {
    _ui_metric.uiMetricService.trackUiMetric(_analytics.METRIC_TYPE.CLICK, _ui_metric.UIM_REINDEX_UNFREEZE_CLICK);
    await updateIndex('unfreeze');
  }, [updateIndex]);
  const onUnfreezeRetry = (0, _react.useCallback)(async () => {
    _ui_metric.uiMetricService.trackUiMetric(_analytics.METRIC_TYPE.CLICK, _ui_metric.UIM_REINDEX_UNFREEZE_RETRY_CLICK);
    await updateIndex('unfreeze');
  }, [updateIndex]);
  const onDeleteIndex = (0, _react.useCallback)(async () => {
    _ui_metric.uiMetricService.trackUiMetric(_analytics.METRIC_TYPE.CLICK, _ui_metric.UIM_REINDEX_DELETE_CLICK);
    await updateIndex('delete');
  }, [updateIndex]);
  const onDeleteRetry = (0, _react.useCallback)(async () => {
    _ui_metric.uiMetricService.trackUiMetric(_analytics.METRIC_TYPE.CLICK, _ui_metric.UIM_REINDEX_DELETE_RETRY_CLICK);
    await updateIndex('delete');
  }, [updateIndex]);
  (0, _react.useEffect)(() => {
    switch (updateIndexStatus) {
      case 'inProgress':
      case 'complete':
      case 'failed':
        {
          setModalStep(updateAction === 'unfreeze' ? 'unfreeze' : updateAction === 'readonly' ? 'makeReadonly' : 'delete');
          break;
        }
      default:
        {
          switch (selectedResolutionType) {
            case 'delete':
              {
                setModalStep('confirmDelete');
                break;
              }
            case 'readonly':
              {
                setModalStep('confirmReadonly');
                break;
              }
            case 'unfreeze':
              setModalStep('confirmUnfreeze');
              break;
            default:
              {
                setModalStep('initializing');
                break;
              }
          }
        }
    }
  }, [correctiveAction === null || correctiveAction === void 0 ? void 0 : correctiveAction.type, onUnfreeze, reindexStatus, selectedResolutionType, updateIndexStatus, updateAction]);
  const modalContent = (0, _react.useMemo)(() => {
    var _reindexState$reindex, _reindexState$reindex2;
    switch (modalStep) {
      case 'initializing':
        return /*#__PURE__*/_react.default.createElement(_initializing_step.InitializingStep, {
          errorMessage: errorMessage,
          type: "index",
          mode: "modal"
        });
      case 'confirmDelete':
        return /*#__PURE__*/_react.default.createElement(_delete_step_modal.DeleteModal, {
          closeModal: closeModal,
          targetName: reindexState.meta.indexName,
          deleteIndex: onDeleteIndex,
          type: "index"
        });
      case 'confirmReadonly':
      case 'confirmUnfreeze':
        return /*#__PURE__*/_react.default.createElement(_warning_step_modal.WarningModalStep, {
          warnings: modalStep === 'confirmReadonly' ? (_reindexState$reindex = (_reindexState$reindex2 = reindexState.reindexWarnings) === null || _reindexState$reindex2 === void 0 ? void 0 : _reindexState$reindex2.filter(({
            flow: warningFlow
          }) => warningFlow === 'readonly')) !== null && _reindexState$reindex !== void 0 ? _reindexState$reindex : [] : [],
          meta: reindexState.meta,
          closeModal: closeModal,
          confirm: () => {
            if (modalStep === 'confirmReadonly') {
              setModalStep('makeReadonly');
              onMakeReadonly();
            } else {
              setModalStep('unfreeze');
              onUnfreeze();
            }
          },
          deprecation: deprecation,
          reindexState: reindexState,
          flow: modalStep === 'confirmReadonly' ? 'readonly' : 'unfreeze'
        });
      case 'unfreeze':
        return /*#__PURE__*/_react.default.createElement(_update_step.UpdateIndexModalStep, {
          action: modalStep,
          meta: reindexState.meta,
          retry: onUnfreezeRetry,
          updateIndexState: updateIndexState,
          closeModal: closeModal
        });
      case 'makeReadonly':
        return /*#__PURE__*/_react.default.createElement(_update_step.UpdateIndexModalStep, {
          action: modalStep,
          meta: reindexState.meta,
          retry: onMakeReadonlyRetry,
          updateIndexState: updateIndexState,
          closeModal: closeModal
        });
      case 'delete':
        return /*#__PURE__*/_react.default.createElement(_update_step.UpdateIndexModalStep, {
          action: modalStep,
          meta: reindexState.meta,
          retry: onDeleteRetry,
          updateIndexState: updateIndexState,
          closeModal: closeModal
        });
    }
  }, [modalStep, errorMessage, reindexState, closeModal, deprecation, onUnfreezeRetry, updateIndexState, onMakeReadonlyRetry, onMakeReadonly, onUnfreeze, onDeleteIndex, onDeleteRetry]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiModal, {
    onClose: closeModal,
    "data-test-subj": "updateIndexModal",
    maxWidth: true,
    css: {
      minWidth: 750
    }
  }, modalContent);
};
exports.IndexModal = IndexModal;