"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useDataStreamMigrationContext = exports.DataStreamMigrationStatusProvider = void 0;
var _react = _interopRequireWildcard(require("react"));
var _use_migration_state = require("./use_migration_state");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DataStreamMigrationContext = /*#__PURE__*/(0, _react.createContext)(undefined);
const useDataStreamMigrationContext = () => {
  const context = (0, _react.useContext)(DataStreamMigrationContext);
  if (context === undefined) {
    throw new Error('useDataStreamMigrationContext must be used within a <DataStreamMigrationStatusProvider />');
  }
  return context;
};
exports.useDataStreamMigrationContext = useDataStreamMigrationContext;
const DataStreamMigrationStatusProvider = ({
  api,
  dataStreamName,
  children
}) => {
  const {
    migrationState,
    cancelReadonly,
    startReindex,
    loadDataStreamMetadata,
    cancelReindex,
    startReadonly,
    initMigration,
    startDelete
  } = (0, _use_migration_state.useMigrationStatus)({
    dataStreamName,
    api
  });
  return /*#__PURE__*/_react.default.createElement(DataStreamMigrationContext.Provider, {
    value: {
      migrationState,
      startReindex,
      cancelReindex,
      startReadonly,
      cancelReadonly,
      initMigration,
      loadDataStreamMetadata,
      startDelete
    }
  }, children);
};
exports.DataStreamMigrationStatusProvider = DataStreamMigrationStatusProvider;