"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DeprecationsCountCallout = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _app_context = require("../../../../app_context");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const i18nTexts = {
  calloutTitle: (warningsCount, previousCheck) => /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.upgradeAssistant.overview.verifyChanges.calloutTitle",
    defaultMessage: "{warningsCount, plural, =0 {No} other {{warningsCount}}} deprecation {warningsCount, plural, one {issue} other {issues}} since {previousCheck}",
    values: {
      warningsCount,
      previousCheck: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedDate, {
        value: previousCheck,
        year: "numeric",
        month: "long",
        day: "2-digit"
      }), ' ', /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedTime, {
        value: previousCheck,
        timeZoneName: "short",
        hour12: false
      }))
    }
  }),
  calloutBody: _i18n.i18n.translate('xpack.upgradeAssistant.overview.verifyChanges.calloutBody', {
    defaultMessage: `After making changes, reset the counter and continue monitoring to verify you're no longer using deprecated features.`
  }),
  loadingError: _i18n.i18n.translate('xpack.upgradeAssistant.overview.verifyChanges.loadingError', {
    defaultMessage: 'An error occurred while retrieving the count of deprecation logs'
  }),
  retryButton: _i18n.i18n.translate('xpack.upgradeAssistant.overview.verifyChanges.retryButton', {
    defaultMessage: 'Try again'
  })
};
const DeprecationsCountCallout = ({
  checkpoint
}) => {
  const {
    services: {
      api
    }
  } = (0, _app_context.useAppContext)();
  const {
    data,
    error,
    isLoading,
    isInitialRequest,
    resendRequest
  } = api.getDeprecationLogsCount(checkpoint);
  const logsCount = (data === null || data === void 0 ? void 0 : data.count) || 0;
  const hasLogs = logsCount > 0;
  const calloutTint = hasLogs ? 'warning' : 'success';
  const calloutIcon = hasLogs ? 'warning' : 'check';
  const calloutTestId = hasLogs ? 'hasWarningsCallout' : 'noWarningsCallout';
  if (isInitialRequest && isLoading) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiSkeletonText, {
      lines: 6
    });
  }
  if (error) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
      title: i18nTexts.loadingError,
      color: "danger",
      iconType: "warning",
      "data-test-subj": "errorCallout"
    }, /*#__PURE__*/_react.default.createElement("p", null, error.statusCode, " - ", error.message), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      color: "danger",
      onClick: resendRequest,
      "data-test-subj": "retryButton"
    }, i18nTexts.retryButton));
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: i18nTexts.calloutTitle(logsCount, checkpoint),
    color: calloutTint,
    iconType: calloutIcon,
    "data-test-subj": calloutTestId
  });
};
exports.DeprecationsCountCallout = DeprecationsCountCallout;