"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.SearchBarUI = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _lodash = require("lodash");
var _i18nReact = require("@kbn/i18n-react");
var _classnames = _interopRequireDefault(require("classnames"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _memoizeOne = _interopRequireDefault(require("memoize-one"));
var _analytics = require("@kbn/analytics");
var _esQuery = require("@kbn/es-query");
var _public = require("@kbn/kibana-react-plugin/public");
var _i18n = require("@kbn/i18n");
var _saved_query_form = require("../saved_query_form");
var _saved_query_management = require("../saved_query_management");
var _query_bar_menu = require("../query_string_input/query_bar_menu");
var _query_bar_top_row = require("../query_string_input/query_bar_top_row");
var _filter_bar = require("../filter_bar");
var _search_bar = require("./search_bar.styles");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

class SearchBarUI extends _react.Component {
  constructor(...args) {
    super(...args);
    (0, _defineProperty2.default)(this, "services", this.props.kibana.services);
    (0, _defineProperty2.default)(this, "savedQueryService", this.services.data.query.savedQueries);
    (0, _defineProperty2.default)(this, "queryBarMenuRef", /*#__PURE__*/(0, _react.createRef)());
    /*
     Keep the "draft" value in local state until the user actually submits the query. There are a couple advantages:
      Each app doesn't have to maintain its own "draft" value if it wants to put off updating the query in app state
     until the user manually submits their changes. Some apps have watches on the query value in app state so we don't
     want to trigger those on every keypress.
    */
    (0, _defineProperty2.default)(this, "state", {
      isFiltersVisible: true,
      openQueryBarMenu: false,
      showSavedQueryPopover: false,
      currentProps: this.props,
      query: this.props.query ? {
        ...this.props.query
      } : undefined,
      dateRangeFrom: (0, _lodash.get)(this.props, 'dateRangeFrom', 'now-15m'),
      dateRangeTo: (0, _lodash.get)(this.props, 'dateRangeTo', 'now')
    });
    (0, _defineProperty2.default)(this, "isDirty", () => {
      if (!this.props.showDatePicker && this.state.query && this.props.query) {
        return !(0, _lodash.isEqual)(this.state.query, this.props.query);
      }
      return this.state.query && this.props.query && !(0, _lodash.isEqual)(this.state.query, this.props.query) || this.state.dateRangeFrom !== this.props.dateRangeFrom || this.state.dateRangeTo !== this.props.dateRangeTo;
    });
    (0, _defineProperty2.default)(this, "onSave", async (savedQueryMeta, saveAsNew = false) => {
      if (!this.state.query) return;
      const savedQueryAttributes = {
        title: savedQueryMeta.title,
        description: savedQueryMeta.description,
        query: this.state.query
      };
      if (savedQueryMeta.shouldIncludeFilters) {
        savedQueryAttributes.filters = this.props.filters;
      }
      const timeFilter = this.getTimeFilter();
      if (savedQueryMeta.shouldIncludeTimefilter && timeFilter) {
        savedQueryAttributes.timefilter = timeFilter;
      }
      try {
        let response;
        if (this.props.savedQuery && !saveAsNew) {
          response = await this.savedQueryService.updateQuery(savedQueryMeta.id, savedQueryAttributes);
        } else {
          response = await this.savedQueryService.createQuery(savedQueryAttributes);
        }
        this.services.notifications.toasts.addSuccess(_i18n.i18n.translate('unifiedSearch.search.searchBar.saveQuerySuccessMessage', {
          defaultMessage: 'Your query "{queryTitle}" was saved',
          values: {
            queryTitle: response.attributes.title
          }
        }));
        if (this.props.onSaved) {
          this.props.onSaved(response);
        }
      } catch (error) {
        this.services.notifications.toasts.addDanger(_i18n.i18n.translate('unifiedSearch.search.searchBar.saveQueryErrorMessage', {
          defaultMessage: 'An error occured while saving your query: {errorMessage}',
          values: {
            errorMessage: error.message
          }
        }));
        throw error;
      }
    });
    (0, _defineProperty2.default)(this, "onQueryBarChange", queryAndDateRange => {
      this.setState({
        query: queryAndDateRange.query,
        dateRangeFrom: queryAndDateRange.dateRange.from,
        dateRangeTo: queryAndDateRange.dateRange.to
      });
      if (this.props.onQueryChange) {
        this.props.onQueryChange(queryAndDateRange);
      }
    });
    (0, _defineProperty2.default)(this, "onTextLangQueryChange", query => {
      this.setState({
        query
      });
      if (this.props.onQueryChange) {
        this.props.onQueryChange({
          query,
          dateRange: {
            from: this.state.dateRangeFrom,
            to: this.state.dateRangeTo
          }
        });
      }
    });
    (0, _defineProperty2.default)(this, "toggleFilterBarMenuPopover", value => {
      this.setState({
        openQueryBarMenu: value
      });
    });
    (0, _defineProperty2.default)(this, "onTextLangQuerySubmit", query => {
      var _this$props$onFilters, _this$props;
      // clean up all filters
      (_this$props$onFilters = (_this$props = this.props).onFiltersUpdated) === null || _this$props$onFilters === void 0 ? void 0 : _this$props$onFilters.call(_this$props, []);
      this.setState({
        query: query
      }, () => {
        if (this.props.onQuerySubmit) {
          this.props.onQuerySubmit({
            query: query,
            dateRange: {
              from: this.state.dateRangeFrom,
              to: this.state.dateRangeTo
            }
          }, this.isDirty());
        }
      });
    });
    (0, _defineProperty2.default)(this, "onQueryBarSubmit", queryAndDateRange => {
      this.setState({
        query: queryAndDateRange.query,
        dateRangeFrom: queryAndDateRange.dateRange && queryAndDateRange.dateRange.from || this.state.dateRangeFrom,
        dateRangeTo: queryAndDateRange.dateRange && queryAndDateRange.dateRange.to || this.state.dateRangeTo
      }, () => {
        var _this$services$usageC;
        if (this.props.onQuerySubmit) {
          this.props.onQuerySubmit({
            query: this.state.query,
            dateRange: {
              from: this.state.dateRangeFrom,
              to: this.state.dateRangeTo
            }
          }, this.isDirty());
        }
        (_this$services$usageC = this.services.usageCollection) === null || _this$services$usageC === void 0 ? void 0 : _this$services$usageC.reportUiCounter(this.services.appName, _analytics.METRIC_TYPE.CLICK, 'query_submitted');
      });
    });
    (0, _defineProperty2.default)(this, "onLoadSavedQuery", savedQuery => {
      const dateRangeFrom = (0, _lodash.get)(savedQuery, 'attributes.timefilter.from', this.state.dateRangeFrom);
      const dateRangeTo = (0, _lodash.get)(savedQuery, 'attributes.timefilter.to', this.state.dateRangeTo);
      this.setState({
        query: savedQuery.attributes.query,
        dateRangeFrom,
        dateRangeTo
      });
      if (this.props.onSavedQueryUpdated) {
        this.props.onSavedQueryUpdated(savedQuery);
      }
    });
    (0, _defineProperty2.default)(this, "renderSavedQueryManagement", (0, _memoizeOne.default)((onClearSavedQuery, showSaveQuery, savedQuery) => {
      const savedQueryManagement = /*#__PURE__*/_react.default.createElement(_saved_query_management.SavedQueryManagementList, {
        showSaveQuery: showSaveQuery,
        loadedSavedQuery: savedQuery,
        savedQueryService: this.savedQueryService,
        queryBarMenuRef: this.queryBarMenuRef,
        onLoad: this.onLoadSavedQuery,
        onClearSavedQuery: onClearSavedQuery,
        onClose: () => this.setState({
          openQueryBarMenu: false
        })
      });
      return savedQueryManagement;
    }));
  }
  static getDerivedStateFromProps(nextProps, prevState) {
    if ((0, _lodash.isEqual)(prevState.currentProps, nextProps)) {
      return null;
    }
    let nextQuery = null;
    if (nextProps.query && (0, _esQuery.isOfQueryType)(nextProps.query) && nextProps.query.query !== (0, _lodash.get)(prevState, 'currentProps.query.query')) {
      nextQuery = {
        query: nextProps.query.query,
        language: nextProps.query.language
      };
    } else if (nextProps.query && prevState.query && (0, _esQuery.isOfQueryType)(nextProps.query) && (0, _esQuery.isOfQueryType)(prevState.query) && nextProps.query.language !== prevState.query.language) {
      nextQuery = {
        query: '',
        language: nextProps.query.language
      };
    } else if (nextProps.query && (0, _esQuery.isOfAggregateQueryType)(nextProps.query) && nextProps.query.esql !== (0, _lodash.get)(prevState, 'currentProps.query.esql')) {
      // this code is just overriding the query with a new one in case the query has changed in props
      // without the props check it would override any edits to the query, if e.g. results were returned and isLoading switches from true to false
      nextQuery = nextProps.query;
    }
    let nextDateRange = null;
    if (nextProps.dateRangeFrom !== (0, _lodash.get)(prevState, 'currentProps.dateRangeFrom') || nextProps.dateRangeTo !== (0, _lodash.get)(prevState, 'currentProps.dateRangeTo')) {
      nextDateRange = {
        dateRangeFrom: nextProps.dateRangeFrom,
        dateRangeTo: nextProps.dateRangeTo
      };
    }
    const nextState = {
      currentProps: nextProps
    };
    if (nextQuery) {
      nextState.query = nextQuery;
    }
    if (nextDateRange) {
      nextState.dateRangeFrom = nextDateRange.dateRangeFrom;
      nextState.dateRangeTo = nextDateRange.dateRangeTo;

      /**
       * Some applications do not rely on the _g url parameter to update the time. The onTimeRangeChange
       * callback can be used in these cases to notify the consumer for the time change.
       */
      if (nextDateRange.dateRangeFrom && nextDateRange.dateRangeTo) {
        var _nextProps$onTimeRang;
        nextProps === null || nextProps === void 0 ? void 0 : (_nextProps$onTimeRang = nextProps.onTimeRangeChange) === null || _nextProps$onTimeRang === void 0 ? void 0 : _nextProps$onTimeRang.call(nextProps, {
          dateRange: {
            from: nextDateRange.dateRangeFrom,
            to: nextDateRange.dateRangeTo
          }
        });
      }
    }
    return nextState;
  }
  componentWillUnmount() {
    this.renderSavedQueryManagement.clear();
  }
  shouldRenderFilterBar() {
    return this.props.showFilterBar && this.props.filters && this.props.indexPatterns && (0, _lodash.compact)(this.props.indexPatterns).length > 0;
  }

  /*
   * This Function is here to show the toggle in saved query form
   * in case you the date range (from/to)
   */
  shouldRenderTimeFilterInSavedQueryForm() {
    const {
      dateRangeFrom,
      dateRangeTo,
      showDatePicker,
      indexPatterns
    } = this.props;
    if (!showDatePicker && dateRangeFrom !== undefined && dateRangeTo !== undefined) {
      return false;
    }
    if (indexPatterns !== null && indexPatterns !== void 0 && indexPatterns.length) {
      // return true if at least one of the DateView has timeFieldName
      return indexPatterns.some(dataView => Boolean(dataView.timeFieldName));
    }
    return true;
  }
  getTimeFilter() {
    if (this.state.dateRangeTo !== undefined && this.state.dateRangeFrom !== undefined && this.props.refreshInterval !== undefined && this.props.isRefreshPaused !== undefined) {
      return {
        from: this.state.dateRangeFrom,
        to: this.state.dateRangeTo,
        refreshInterval: {
          value: this.props.refreshInterval,
          pause: this.props.isRefreshPaused
        }
      };
    }
  }
  shouldShowDatePickerAsBadge() {
    return this.shouldRenderFilterBar() && !this.props.showQueryInput;
  }
  render() {
    var _this$state, _this$state2, _this$state2$query, _this$props$additiona;
    const {
      theme,
      query
    } = this.props;
    const isESQLQuery = (0, _esQuery.isOfAggregateQueryType)(query);
    const isScreenshotMode = this.props.isScreenshotMode === true;
    const styles = (0, _search_bar.searchBarStyles)(theme, isESQLQuery);
    const cssStyles = [styles.uniSearchBar, this.props.displayStyle && styles[this.props.displayStyle], isScreenshotMode && styles.hidden];
    const classes = (0, _classnames.default)('uniSearchBar', 'hide-for-sharing', {
      [`uniSearchBar--hidden`]: isScreenshotMode,
      [`uniSearchBar--${this.props.displayStyle}`]: this.props.displayStyle
    });
    const timeRangeForSuggestionsOverride = this.props.showDatePicker ? undefined : false;
    const saveAsNewQueryFormComponent = /*#__PURE__*/_react.default.createElement(_saved_query_form.SaveQueryForm, {
      savedQueryService: this.savedQueryService,
      onSave: savedQueryMeta => this.onSave(savedQueryMeta, true),
      onClose: () => this.setState({
        openQueryBarMenu: false
      }),
      showFilterOption: this.props.showFilterBar,
      showTimeFilterOption: this.shouldRenderTimeFilterInSavedQueryForm()
    });
    const saveQueryFormComponent = /*#__PURE__*/_react.default.createElement(_saved_query_form.SaveQueryForm, {
      savedQuery: this.props.savedQuery ? this.props.savedQuery : undefined,
      savedQueryService: this.savedQueryService,
      onSave: this.onSave,
      onClose: () => this.setState({
        openQueryBarMenu: false
      }),
      showFilterOption: this.props.showFilterBar,
      showTimeFilterOption: this.shouldRenderTimeFilterInSavedQueryForm()
    });
    const queryBarMenu = this.props.showQueryMenu ? /*#__PURE__*/_react.default.createElement(_query_bar_menu.QueryBarMenu, {
      nonKqlMode: this.props.nonKqlMode,
      disableQueryLanguageSwitcher: this.props.disableQueryLanguageSwitcher,
      language: this.state.query && (0, _esQuery.isOfQueryType)((_this$state = this.state) === null || _this$state === void 0 ? void 0 : _this$state.query) ? (_this$state2 = this.state) === null || _this$state2 === void 0 ? void 0 : (_this$state2$query = _this$state2.query) === null || _this$state2$query === void 0 ? void 0 : _this$state2$query.language : 'kuery',
      onQueryChange: this.onQueryBarChange,
      onQueryBarSubmit: this.onQueryBarSubmit,
      dateRangeFrom: this.state.dateRangeFrom,
      dateRangeTo: this.state.dateRangeTo,
      timeFilter: this.getTimeFilter(),
      savedQueryService: this.savedQueryService,
      saveAsNewQueryFormComponent: saveAsNewQueryFormComponent,
      saveFormComponent: saveQueryFormComponent,
      toggleFilterBarMenuPopover: this.toggleFilterBarMenuPopover,
      openQueryBarMenu: this.state.openQueryBarMenu,
      onFiltersUpdated: this.props.onFiltersUpdated,
      filters: this.props.filters,
      additionalQueryBarMenuItems: (_this$props$additiona = this.props.additionalQueryBarMenuItems) !== null && _this$props$additiona !== void 0 ? _this$props$additiona : {},
      hiddenPanelOptions: this.props.hiddenFilterPanelOptions,
      query: this.state.query,
      savedQuery: this.props.savedQuery,
      onClearSavedQuery: this.props.onClearSavedQuery,
      showQueryInput: this.props.showQueryInput,
      showFilterBar: this.props.showFilterBar,
      showSaveQuery: this.props.showSaveQuery,
      showSavedQueryControls: this.props.showSavedQueryControls,
      isDisabled: this.props.isDisabled,
      buttonProps: {
        size: this.shouldShowDatePickerAsBadge() ? 's' : 'm'
      },
      indexPatterns: this.props.indexPatterns,
      timeRangeForSuggestionsOverride: timeRangeForSuggestionsOverride,
      filtersForSuggestions: this.props.filtersForSuggestions,
      manageFilterSetComponent: this.props.showFilterBar && this.state.query && this.props.onClearSavedQuery ? this.renderSavedQueryManagement(this.props.onClearSavedQuery, this.props.showSaveQuery, this.props.savedQuery) : undefined,
      suggestionsAbstraction: this.props.suggestionsAbstraction,
      renderQueryInputAppend: this.props.renderQueryInputAppend,
      queryBarMenuRef: this.queryBarMenuRef
    }) : undefined;
    let filterBar;
    if (this.shouldRenderFilterBar()) {
      filterBar = this.shouldShowDatePickerAsBadge() ? /*#__PURE__*/_react.default.createElement(_filter_bar.FilterItems, {
        filters: this.props.filters,
        onFiltersUpdated: this.props.onFiltersUpdated,
        indexPatterns: this.props.indexPatterns,
        timeRangeForSuggestionsOverride: timeRangeForSuggestionsOverride,
        filtersForSuggestions: this.props.filtersForSuggestions,
        hiddenPanelOptions: this.props.hiddenFilterPanelOptions,
        readOnly: this.props.isDisabled,
        suggestionsAbstraction: this.props.suggestionsAbstraction
      }) : /*#__PURE__*/_react.default.createElement(_filter_bar.FilterBar, {
        afterQueryBar: true,
        filters: this.props.filters,
        onFiltersUpdated: this.props.onFiltersUpdated,
        indexPatterns: this.props.indexPatterns,
        timeRangeForSuggestionsOverride: timeRangeForSuggestionsOverride,
        filtersForSuggestions: this.props.filtersForSuggestions,
        hiddenPanelOptions: this.props.hiddenFilterPanelOptions,
        isDisabled: this.props.isDisabled,
        "data-test-subj": "unifiedFilterBar",
        prepend: this.props.prependFilterBar,
        suggestionsAbstraction: this.props.suggestionsAbstraction
      });
    }
    return /*#__PURE__*/_react.default.createElement("div", {
      className: classes,
      css: cssStyles,
      "data-test-subj": "globalQueryBar"
    }, /*#__PURE__*/_react.default.createElement(_query_bar_top_row.QueryBarTopRow, {
      timeHistory: this.props.timeHistory,
      query: this.state.query,
      screenTitle: this.props.screenTitle,
      onSubmit: this.onQueryBarSubmit,
      indexPatterns: this.props.indexPatterns,
      isLoading: this.props.isLoading,
      fillSubmitButton: this.props.fillSubmitButton || false,
      prepend: this.props.showFilterBar || this.props.showQueryInput ? queryBarMenu : undefined,
      showDatePicker: this.props.showDatePicker,
      dateRangeFrom: this.state.dateRangeFrom,
      dateRangeTo: this.state.dateRangeTo,
      isRefreshPaused: this.props.isRefreshPaused,
      refreshInterval: this.props.refreshInterval,
      minRefreshInterval: this.props.minRefreshInterval,
      showAutoRefreshOnly: this.props.showAutoRefreshOnly,
      showQueryInput: this.props.showQueryInput,
      showAddFilter: this.props.showFilterBar,
      isDisabled: this.props.isDisabled,
      onRefresh: this.props.onRefresh,
      onRefreshChange: this.props.onRefreshChange,
      onCancel: this.props.onCancel,
      onChange: this.onQueryBarChange,
      isDirty: this.isDirty(),
      customSubmitButton: this.props.customSubmitButton ? this.props.customSubmitButton : undefined,
      dataViewPickerOverride: this.props.dataViewPickerOverride,
      showSubmitButton: this.props.showSubmitButton,
      submitButtonStyle: this.props.submitButtonStyle,
      dataTestSubj: this.props.dataTestSubj,
      indicateNoData: this.props.indicateNoData,
      placeholder: this.props.placeholder,
      isClearable: this.props.isClearable,
      iconType: this.props.iconType,
      nonKqlMode: this.props.nonKqlMode,
      timeRangeForSuggestionsOverride: timeRangeForSuggestionsOverride,
      filtersForSuggestions: this.props.filtersForSuggestions,
      filters: this.props.filters,
      onFiltersUpdated: this.props.onFiltersUpdated,
      dataViewPickerComponentProps: this.props.dataViewPickerComponentProps,
      textBasedLanguageModeErrors: this.props.textBasedLanguageModeErrors,
      textBasedLanguageModeWarning: this.props.textBasedLanguageModeWarning,
      showDatePickerAsBadge: this.shouldShowDatePickerAsBadge(),
      filterBar: filterBar,
      suggestionsSize: this.props.suggestionsSize,
      isScreenshotMode: this.props.isScreenshotMode,
      onTextLangQuerySubmit: this.onTextLangQuerySubmit,
      onTextLangQueryChange: this.onTextLangQueryChange,
      submitOnBlur: this.props.submitOnBlur,
      suggestionsAbstraction: this.props.suggestionsAbstraction,
      renderQueryInputAppend: this.props.renderQueryInputAppend,
      disableExternalPadding: this.props.displayStyle === 'withBorders',
      onESQLDocsFlyoutVisibilityChanged: this.props.onESQLDocsFlyoutVisibilityChanged,
      bubbleSubmitEvent: this.props.bubbleSubmitEvent
    }));
  }
}

// Needed for React.lazy
// eslint-disable-next-line import/no-default-export
exports.SearchBarUI = SearchBarUI;
(0, _defineProperty2.default)(SearchBarUI, "defaultProps", {
  showQueryMenu: true,
  showFilterBar: true,
  showDatePicker: true,
  showSubmitButton: true,
  showAutoRefreshOnly: false,
  filtersForSuggestions: [],
  additionalQueryBarMenuItems: []
});
var _default = exports.default = (0, _i18nReact.injectI18n)((0, _eui.withEuiTheme)((0, _public.withKibana)(SearchBarUI)));