"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PanelTitle = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _useEffectOnce = _interopRequireDefault(require("react-use/lib/useEffectOnce"));
var _query_bar_menu_panels = require("./query_bar_menu_panels");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const PanelTitle = ({
  queryBarMenuRef,
  title,
  append
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const titleRef = (0, _react.useRef)(null);
  const onTitleClick = (0, _react.useCallback)(() => {
    var _queryBarMenuRef$curr;
    return (_queryBarMenuRef$curr = queryBarMenuRef.current) === null || _queryBarMenuRef$curr === void 0 ? void 0 : _queryBarMenuRef$curr.showPanel(_query_bar_menu_panels.QueryBarMenuPanel.main, 'previous');
  }, [queryBarMenuRef]);
  const onTitleKeyDown = (0, _react.useCallback)(event => {
    var _queryBarMenuRef$curr2, _queryBarMenuRef$curr3;
    if (event.key !== _eui.keys.ARROW_LEFT) {
      return;
    }
    event.preventDefault();
    event.stopPropagation();
    (_queryBarMenuRef$curr2 = queryBarMenuRef.current) === null || _queryBarMenuRef$curr2 === void 0 ? void 0 : _queryBarMenuRef$curr2.showPreviousPanel();
    (_queryBarMenuRef$curr3 = queryBarMenuRef.current) === null || _queryBarMenuRef$curr3 === void 0 ? void 0 : _queryBarMenuRef$curr3.onUseKeyboardToNavigate();
  }, [queryBarMenuRef]);
  (0, _useEffectOnce.default)(() => {
    var _titleRef$current;
    const panel = (_titleRef$current = titleRef.current) === null || _titleRef$current === void 0 ? void 0 : _titleRef$current.closest('.euiContextMenuPanel');
    const focus = () => {
      var _titleRef$current2;
      return (_titleRef$current2 = titleRef.current) === null || _titleRef$current2 === void 0 ? void 0 : _titleRef$current2.focus();
    };
    panel === null || panel === void 0 ? void 0 : panel.addEventListener('animationend', focus, {
      once: true
    });
    return () => panel === null || panel === void 0 ? void 0 : panel.removeEventListener('animationend', focus);
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    responsive: false,
    gutterSize: "none",
    alignItems: "center",
    css: [(0, _eui.logicalCSS)('border-bottom', euiTheme.border.thin)]
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xxs"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
    buttonRef: titleRef,
    className: "euiContextMenuPanel__title",
    icon: "arrowLeft",
    onClick: onTitleClick,
    onKeyDown: onTitleKeyDown,
    "data-test-subj": "contextMenuPanelTitleButton",
    css: {
      '&:enabled:focus': {
        /* Override the default focus background on EUiContextMenuItems */
        backgroundColor: 'unset'
      }
    }
  }, title))), append && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    css: {
      paddingInline: euiTheme.size.s
    }
  }, append));
};
exports.PanelTitle = PanelTitle;