"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ChangeDataView = ChangeDataView;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _i18n = require("@kbn/i18n");
var _react = _interopRequireWildcard(require("react"));
var _react2 = require("@emotion/react");
var _eui = require("@elastic/eui");
var _public = require("@kbn/kibana-react-plugin/public");
var _adhoc = _interopRequireDefault(require("./assets/adhoc.svg"));
var _change_dataview = require("./change_dataview.styles");
var _data_view_selector = require("./data_view_selector");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const mapDataViewListItem = (dataView, partial) => ({
  title: dataView.title,
  name: dataView.name,
  id: dataView.id,
  type: dataView.type,
  ...partial
});
const mapAdHocDataView = adHocDataView => mapDataViewListItem(adHocDataView, {
  isAdhoc: true
});
const mapManagedDataView = managedDataView => mapDataViewListItem(managedDataView, {
  isManaged: true
});
const shrinkableContainerCss = (0, _react2.css)`
  min-width: 0;
`;
function ChangeDataView({
  isMissingCurrent,
  currentDataViewId,
  adHocDataViews,
  managedDataViews,
  savedDataViews,
  onChangeDataView,
  onAddField,
  onDataViewCreated,
  trigger,
  selectableProps,
  isDisabled,
  onEditDataView,
  onCreateDefaultAdHocDataView,
  onClosePopover
}) {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const [isPopoverOpen, setPopoverIsOpen] = (0, _react.useState)(false);
  const [dataViewsList, setDataViewsList] = (0, _react.useState)([]);
  const kibana = (0, _public.useKibana)();
  const {
    application,
    data,
    dataViews,
    dataViewEditor
  } = kibana.services;
  const isMobile = (0, _eui.useIsWithinBreakpoints)(['xs']);
  const styles = (0, _change_dataview.changeDataViewStyles)({
    fullWidth: trigger.fullWidth,
    dataViewsList,
    theme: euiTheme,
    isMobile
  });

  // Create a reusable id to ensure search input is the first focused item in the popover even though it's not the first item
  const searchListInputId = (0, _eui.useGeneratedHtmlId)({
    prefix: 'dataviewPickerListSearchInput'
  });
  const closePopover = (0, _react.useCallback)(() => {
    setPopoverIsOpen(false);
    if (onClosePopover) {
      onClosePopover();
    }
  }, [onClosePopover]);
  (0, _react.useEffect)(() => {
    const fetchDataViews = async () => {
      var _await$data$dataViews, _adHocDataViews$map, _managedDataViews$map;
      const savedDataViewRefs = savedDataViews ? savedDataViews : (_await$data$dataViews = await data.dataViews.getIdsWithTitle()) !== null && _await$data$dataViews !== void 0 ? _await$data$dataViews : [];
      const adHocDataViewRefs = (_adHocDataViews$map = adHocDataViews === null || adHocDataViews === void 0 ? void 0 : adHocDataViews.map(mapAdHocDataView)) !== null && _adHocDataViews$map !== void 0 ? _adHocDataViews$map : [];
      const managedDataViewRefs = (_managedDataViews$map = managedDataViews === null || managedDataViews === void 0 ? void 0 : managedDataViews.map(mapManagedDataView)) !== null && _managedDataViews$map !== void 0 ? _managedDataViews$map : [];
      setDataViewsList([...savedDataViewRefs, ...adHocDataViewRefs, ...managedDataViewRefs]);
    };
    fetchDataViews();
  }, [data, currentDataViewId, adHocDataViews, savedDataViews, managedDataViews]);
  const isAdHocSelected = (0, _react.useMemo)(() => {
    return adHocDataViews === null || adHocDataViews === void 0 ? void 0 : adHocDataViews.some(dataView => dataView.id === currentDataViewId);
  }, [adHocDataViews, currentDataViewId]);
  const createTrigger = function () {
    const {
      label,
      title,
      'data-test-subj': dataTestSubj,
      fullWidth,
      ...rest
    } = trigger;
    return /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, (0, _extends2.default)({
      css: styles.trigger,
      "data-test-subj": dataTestSubj,
      onClick: () => {
        setPopoverIsOpen(!isPopoverOpen);
      },
      color: isMissingCurrent ? 'danger' : 'text',
      iconSide: "right",
      iconType: "arrowDown",
      title: trigger.label,
      disabled: isDisabled,
      textProps: {
        className: 'eui-textTruncate'
      }
    }, rest), /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, isAdHocSelected && /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: _adhoc.default,
      color: "primary",
      css: (0, _react2.css)`
                margin-right: ${euiTheme.size.s};
              `
    }), trigger.label));
  };
  const items = (0, _react.useMemo)(() => {
    const panelItems = [];
    if (onAddField) {
      panelItems.push(/*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
        key: "add",
        icon: "indexOpen",
        "data-test-subj": "indexPattern-add-field",
        onClick: () => {
          closePopover();
          onAddField();
        }
      }, _i18n.i18n.translate('unifiedSearch.query.queryBar.indexPattern.addFieldButton', {
        defaultMessage: 'Add a field to this data view'
      })), onEditDataView || dataViewEditor.userPermissions.editDataView() ? /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
        key: "manage",
        icon: "indexSettings",
        "data-test-subj": "indexPattern-manage-field",
        onClick: async () => {
          if (onEditDataView) {
            const dataView = await dataViews.get(currentDataViewId);
            dataViewEditor.openEditor({
              editData: dataView,
              onSave: updatedDataView => {
                onEditDataView(updatedDataView);
              }
            });
          } else {
            application.navigateToApp('management', {
              path: `/kibana/indexPatterns/patterns/${currentDataViewId}`
            });
          }
          closePopover();
        }
      }, _i18n.i18n.translate('unifiedSearch.query.queryBar.indexPattern.manageFieldButton', {
        defaultMessage: 'Manage this data view'
      })) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, {
        key: "empty"
      }), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
        margin: "none",
        key: "dataviewActions-divider"
      }));
    }
    panelItems.push(/*#__PURE__*/_react.default.createElement(_react.default.Fragment, {
      key: "add-dataview"
    }, onDataViewCreated && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      alignItems: "center",
      gutterSize: "none",
      justifyContent: "spaceBetween",
      responsive: false,
      css: (0, _react2.css)`
              margin: ${euiTheme.size.s};
              margin-bottom: 0;
            `
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      alignItems: "center",
      gutterSize: "xs",
      responsive: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s"
    }, /*#__PURE__*/_react.default.createElement("h5", null, _i18n.i18n.translate('unifiedSearch.query.queryBar.indexPattern.dataViewsLabel', {
      defaultMessage: 'Data views'
    })))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      onClick: () => {
        closePopover();
        onDataViewCreated();
      },
      size: "xs",
      iconType: "plusInCircleFilled",
      iconSide: "left",
      "data-test-subj": "dataview-create-new"
    }, _i18n.i18n.translate('unifiedSearch.query.queryBar.indexPattern.addNewDataView', {
      defaultMessage: 'Create a data view'
    })))), /*#__PURE__*/_react.default.createElement(_data_view_selector.DataViewSelector, {
      currentDataViewId: currentDataViewId,
      searchListInputId: searchListInputId,
      dataViewsList: dataViewsList,
      selectableProps: selectableProps,
      setPopoverIsOpen: setPopoverIsOpen,
      onChangeDataView: async newId => {
        closePopover();
        onChangeDataView(newId);
      },
      onCreateDefaultAdHocDataView: onCreateDefaultAdHocDataView
    })));
    return panelItems;
  }, [application, closePopover, currentDataViewId, dataViewEditor, dataViews, dataViewsList, euiTheme.size.s, onAddField, onChangeDataView, onCreateDefaultAdHocDataView, onDataViewCreated, onEditDataView, searchListInputId, selectableProps]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "s",
    responsive: false
  }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true,
    css: shrinkableContainerCss
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "none",
    responsive: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    css: (0, _react2.css)`
                padding: 11px;
                border-radius: ${euiTheme.border.radius.small} 0 0 ${euiTheme.border.radius.small};
                background-color: ${euiTheme.colors.lightestShade};
                border: ${euiTheme.border.width.thin} solid ${euiTheme.colors.borderBasePlain};
                border-right: 0;
              `
  }, _i18n.i18n.translate('unifiedSearch.query.queryBar.esqlMenu.switcherLabelTitle', {
    defaultMessage: 'Data view'
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true,
    css: shrinkableContainerCss
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    panelClassName: "changeDataViewPopover",
    button: createTrigger(),
    panelProps: {
      ['data-test-subj']: 'changeDataViewPopover'
    },
    isOpen: isPopoverOpen,
    closePopover: () => setPopoverIsOpen(false),
    panelPaddingSize: "none",
    initialFocus: `[id="${searchListInputId}"]`,
    display: "block",
    buffer: 8
  }, /*#__PURE__*/_react.default.createElement("div", {
    css: styles.popoverContent
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuPanel, {
    size: "s",
    items: items
  }))))))));
}