"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.setupValueSuggestionProvider = exports.getEmptyValueSuggestions = void 0;
var _datemath = _interopRequireDefault(require("@kbn/datemath"));
var _lodash = require("lodash");
var _common = require("@kbn/data-plugin/common");
var _esQuery = require("@kbn/es-query");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const getAutocompleteTimefilter = ({
  timefilter
}, indexPattern) => {
  const timeRange = timefilter.getTime();

  // Use a rounded timerange so that memoizing works properly
  const roundedTimerange = {
    from: _datemath.default.parse(timeRange.from).startOf('minute').toISOString(),
    to: _datemath.default.parse(timeRange.to, {
      roundUp: true
    }).endOf('minute').toISOString()
  };
  return timefilter.createFilter(indexPattern, roundedTimerange);
};
const getEmptyValueSuggestions = () => Promise.resolve([]);
exports.getEmptyValueSuggestions = getEmptyValueSuggestions;
const setupValueSuggestionProvider = (core, {
  timefilter,
  usageCollector
}) => {
  function resolver(title, field, query, filters) {
    // Only cache results for a minute
    const ttl = Math.floor(Date.now() / 1000 / 60);
    return [ttl, query, title, field.name, JSON.stringify(filters)].join('|');
  }
  const requestSuggestions = (0, _lodash.memoize)((index, field, query, filters = [], signal, method = core.uiSettings.get(_common.UI_SETTINGS.AUTOCOMPLETE_VALUE_SUGGESTION_METHOD), querySuggestionKey) => {
    var _field$toSpec, _field$toSpec2;
    usageCollector === null || usageCollector === void 0 ? void 0 : usageCollector.trackRequest();
    let path = `/internal/kibana/suggestions/values/${index}`;
    if (querySuggestionKey) {
      path = `/internal/${querySuggestionKey}/suggestions/values`;
    }
    return core.http.fetch(path, {
      method: 'POST',
      body: JSON.stringify({
        query,
        field: field.name,
        fieldMeta: (_field$toSpec = (_field$toSpec2 = field.toSpec) === null || _field$toSpec2 === void 0 ? void 0 : _field$toSpec2.call(field)) !== null && _field$toSpec !== void 0 ? _field$toSpec : field,
        filters,
        ...(querySuggestionKey === undefined ? {
          method
        } : {})
      }),
      signal,
      version: '1'
    }).then(r => {
      usageCollector === null || usageCollector === void 0 ? void 0 : usageCollector.trackResult();
      return r;
    });
  }, resolver);
  return async ({
    indexPattern,
    field,
    query,
    useTimeRange,
    boolFilter,
    signal,
    method,
    querySuggestionKey
  }) => {
    var _useTimeRange, _field$esTypes;
    const shouldSuggestValues = core.uiSettings.get(_common.UI_SETTINGS.FILTERS_EDITOR_SUGGEST_VALUES);
    useTimeRange = (_useTimeRange = useTimeRange) !== null && _useTimeRange !== void 0 ? _useTimeRange : core.uiSettings.get(_common.UI_SETTINGS.AUTOCOMPLETE_USE_TIMERANGE);
    const {
      title
    } = indexPattern;
    const isVersionFieldType = field.type === 'string' && ((_field$esTypes = field.esTypes) === null || _field$esTypes === void 0 ? void 0 : _field$esTypes.includes('version'));
    if (field.type === 'boolean') {
      return [true, false];
    } else if (!shouldSuggestValues || !field.aggregatable || field.type !== 'string' && field.type !== 'ip' || isVersionFieldType // suggestions don't work for version fields
    ) {
      return [];
    }
    const timeFilter = useTimeRange ? getAutocompleteTimefilter(timefilter, indexPattern) : undefined;
    const filterQuery = timeFilter ? (0, _esQuery.buildQueryFromFilters)([timeFilter], indexPattern).filter : [];
    const filters = [...(boolFilter ? boolFilter : []), ...filterQuery];
    try {
      usageCollector === null || usageCollector === void 0 ? void 0 : usageCollector.trackCall();
      return await requestSuggestions(title, field, query, filters, signal, method, querySuggestionKey);
    } catch (e) {
      if (!(signal !== null && signal !== void 0 && signal.aborted)) {
        usageCollector === null || usageCollector === void 0 ? void 0 : usageCollector.trackError();
      }
      // Remove rejected results from memoize cache
      requestSuggestions.cache.delete(resolver(title, field, query, filters));
      return [];
    }
  };
};
exports.setupValueSuggestionProvider = setupValueSuggestionProvider;