"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.setupGetFieldSuggestions = void 0;
var _public = require("@kbn/data-plugin/public");
var _lodash = require("lodash");
var _esQuery = require("@kbn/es-query");
var _sort_prefix_first = require("./sort_prefix_first");
var _query_suggestion_provider = require("../query_suggestion_provider");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const keywordComparator = (first, second) => {
  const extensions = ['raw', 'keyword'];
  if (extensions.map(ext => `${first.name}.${ext}`).includes(second.name)) {
    return 1;
  } else if (extensions.map(ext => `${second.name}.${ext}`).includes(first.name)) {
    return -1;
  }
  return first.name.localeCompare(second.name);
};
const setupGetFieldSuggestions = core => {
  return async ({
    indexPatterns,
    suggestionsAbstraction
  }, {
    start,
    end,
    prefix,
    suffix,
    nestedPath = ''
  }) => {
    const allFields = (0, _lodash.flatten)(indexPatterns.map(indexPattern => {
      return indexPattern.fields.filter(_public.indexPatterns.isFilterable);
    })
    // temp until IIndexPattern => DataView
    );
    const search = `${prefix}${suffix}`.trim().toLowerCase();
    const matchingFields = allFields.filter(field => {
      var _suggestionsAbstracti;
      const subTypeNested = _public.indexPatterns.getFieldSubtypeNested(field);
      if (suggestionsAbstraction !== null && suggestionsAbstraction !== void 0 && (_suggestionsAbstracti = suggestionsAbstraction.fields) !== null && _suggestionsAbstracti !== void 0 && _suggestionsAbstracti[field.name]) {
        var _suggestionsAbstracti2, _suggestionsAbstracti3;
        return (!nestedPath || nestedPath && (subTypeNested === null || subTypeNested === void 0 ? void 0 : subTypeNested.nested.path.includes(nestedPath))) && ((_suggestionsAbstracti2 = suggestionsAbstraction === null || suggestionsAbstraction === void 0 ? void 0 : (_suggestionsAbstracti3 = suggestionsAbstraction.fields[field.name]) === null || _suggestionsAbstracti3 === void 0 ? void 0 : _suggestionsAbstracti3.displayField) !== null && _suggestionsAbstracti2 !== void 0 ? _suggestionsAbstracti2 : '').toLowerCase().includes(search);
      } else {
        return (!nestedPath || nestedPath && (subTypeNested === null || subTypeNested === void 0 ? void 0 : subTypeNested.nested.path.includes(nestedPath))) && field.name.toLowerCase().includes(search);
      }
    });
    const sortedFields = (0, _sort_prefix_first.sortPrefixFirst)(matchingFields.sort(keywordComparator), search, 'name');
    const suggestions = sortedFields.map(field => {
      var _suggestionsAbstracti4, _suggestionsAbstracti5;
      const isNested = field.subType && field.subType.nested;
      const isSuggestionsAbstractionOn = !!(suggestionsAbstraction !== null && suggestionsAbstraction !== void 0 && (_suggestionsAbstracti4 = suggestionsAbstraction.fields) !== null && _suggestionsAbstracti4 !== void 0 && _suggestionsAbstracti4[field.name]);
      const remainingPath = field.subType && field.subType.nested ? isSuggestionsAbstractionOn ? ((_suggestionsAbstracti5 = suggestionsAbstraction === null || suggestionsAbstraction === void 0 ? void 0 : suggestionsAbstraction.fields[field.name].displayField) !== null && _suggestionsAbstracti5 !== void 0 ? _suggestionsAbstracti5 : '').slice(nestedPath ? nestedPath.length + 1 : 0) : field.subType.nested.path.slice(nestedPath ? nestedPath.length + 1 : 0) : '';
      let text = isNested && remainingPath.length > 0 ? `${(0, _esQuery.escapeKuery)(remainingPath)}:{ ${(0, _esQuery.escapeKuery)(field.name.slice(field.subType.nested.path.length + 1))}  }` : `${(0, _esQuery.escapeKuery)(field.name.slice(nestedPath ? nestedPath.length + 1 : 0))} `;
      if (isSuggestionsAbstractionOn) {
        if (isNested && remainingPath.length > 0) {
          var _suggestionsAbstracti6, _suggestionsAbstracti7;
          text = `${(0, _esQuery.escapeKuery)(remainingPath)}:{ ${(0, _esQuery.escapeKuery)((_suggestionsAbstracti6 = suggestionsAbstraction === null || suggestionsAbstraction === void 0 ? void 0 : (_suggestionsAbstracti7 = suggestionsAbstraction.fields[field.name]) === null || _suggestionsAbstracti7 === void 0 ? void 0 : _suggestionsAbstracti7.nestedDisplayField) !== null && _suggestionsAbstracti6 !== void 0 ? _suggestionsAbstracti6 : '')}  }`;
        } else if (isNested && remainingPath.length === 0) {
          var _suggestionsAbstracti8, _suggestionsAbstracti9;
          text = (_suggestionsAbstracti8 = suggestionsAbstraction === null || suggestionsAbstraction === void 0 ? void 0 : (_suggestionsAbstracti9 = suggestionsAbstraction.fields[field.name]) === null || _suggestionsAbstracti9 === void 0 ? void 0 : _suggestionsAbstracti9.nestedDisplayField) !== null && _suggestionsAbstracti8 !== void 0 ? _suggestionsAbstracti8 : '';
        } else {
          var _suggestionsAbstracti10;
          text = (_suggestionsAbstracti10 = suggestionsAbstraction === null || suggestionsAbstraction === void 0 ? void 0 : suggestionsAbstraction.fields[field.name].displayField) !== null && _suggestionsAbstracti10 !== void 0 ? _suggestionsAbstracti10 : '';
        }
      }
      const cursorIndex = isNested && remainingPath.length > 0 ? text.length - 2 : text.length;
      return {
        type: _query_suggestion_provider.QuerySuggestionTypes.Field,
        text,
        start,
        end,
        cursorIndex,
        field
      };
    });
    return Promise.resolve(suggestions);
  };
};
exports.setupGetFieldSuggestions = setupGetFieldSuggestions;