"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LensVisServiceStatus = exports.LensVisService = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _rxjs = require("rxjs");
var _lodash = require("lodash");
var _esqlUtils = require("@kbn/esql-utils");
var _esQuery = require("@kbn/es-query");
var _i18n = require("@kbn/i18n");
var _visualizationUtils = require("@kbn/visualization-utils");
var _public = require("@kbn/visualizations-plugin/public");
var _fieldUtils = require("@kbn/field-utils");
var _types = require("../types");
var _external_vis_context = require("../utils/external_vis_context");
var _lens_vis_from_table = require("../utils/lens_vis_from_table");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const UNIFIED_HISTOGRAM_LAYER_ID = 'unifiedHistogram';
const stateSelectorFactory = state$ => (selector, equalityFn) => state$.pipe((0, _rxjs.map)(selector), (0, _rxjs.distinctUntilChanged)(equalityFn));
let LensVisServiceStatus = exports.LensVisServiceStatus = /*#__PURE__*/function (LensVisServiceStatus) {
  LensVisServiceStatus["initial"] = "initial";
  LensVisServiceStatus["completed"] = "completed";
  return LensVisServiceStatus;
}({});
class LensVisService {
  constructor({
    services,
    lensSuggestionsApi
  }) {
    (0, _defineProperty2.default)(this, "state$", void 0);
    (0, _defineProperty2.default)(this, "services", void 0);
    (0, _defineProperty2.default)(this, "lensSuggestionsApi", void 0);
    (0, _defineProperty2.default)(this, "status$", void 0);
    (0, _defineProperty2.default)(this, "currentSuggestionContext$", void 0);
    (0, _defineProperty2.default)(this, "visContext$", void 0);
    (0, _defineProperty2.default)(this, "prevUpdateContext", void 0);
    (0, _defineProperty2.default)(this, "update", ({
      externalVisContext,
      queryParams,
      timeInterval,
      breakdownField,
      table,
      onSuggestionContextChange,
      onVisContextChanged,
      getModifiedVisAttributes
    }) => {
      const suggestionState = this.getCurrentSuggestionState({
        externalVisContext,
        queryParams,
        timeInterval,
        breakdownField
      });
      const lensAttributesState = this.getLensAttributesState({
        currentSuggestionContext: suggestionState.currentSuggestionContext,
        externalVisContext,
        queryParams,
        timeInterval,
        breakdownField,
        table,
        getModifiedVisAttributes
      });
      onSuggestionContextChange(suggestionState.currentSuggestionContext);
      onVisContextChanged === null || onVisContextChanged === void 0 ? void 0 : onVisContextChanged(lensAttributesState.visContext, lensAttributesState.externalVisContextStatus);
      this.state$.next({
        status: LensVisServiceStatus.completed,
        currentSuggestionContext: suggestionState.currentSuggestionContext,
        visContext: lensAttributesState.visContext
      });
      this.prevUpdateContext = {
        queryParams,
        timeInterval,
        breakdownField,
        table,
        onSuggestionContextChange,
        onVisContextChanged
      };
    });
    (0, _defineProperty2.default)(this, "onSuggestionEdited", ({
      editedSuggestionContext
    }) => {
      if (!editedSuggestionContext || !this.prevUpdateContext) {
        return;
      }
      const {
        queryParams,
        timeInterval,
        breakdownField,
        table,
        onVisContextChanged
      } = this.prevUpdateContext;
      const lensAttributesState = this.getLensAttributesState({
        currentSuggestionContext: editedSuggestionContext,
        externalVisContext: undefined,
        queryParams,
        timeInterval,
        breakdownField,
        table
      });
      onVisContextChanged === null || onVisContextChanged === void 0 ? void 0 : onVisContextChanged(lensAttributesState.visContext, _types.UnifiedHistogramExternalVisContextStatus.manuallyCustomized);
    });
    (0, _defineProperty2.default)(this, "getCurrentSuggestionState", ({
      externalVisContext,
      queryParams,
      timeInterval,
      breakdownField
    }) => {
      let type = _types.UnifiedHistogramSuggestionType.unsupported;
      let currentSuggestion;
      const availableSuggestionsWithType = [];
      if (queryParams.isPlainRecord) {
        if ((0, _esQuery.isOfAggregateQueryType)(queryParams.query)) {
          if ((0, _esqlUtils.hasTransformationalCommand)(queryParams.query.esql)) {
            // appends the first lens suggestion if available
            const allSuggestions = this.getAllSuggestions({
              queryParams,
              preferredVisAttributes: externalVisContext === null || externalVisContext === void 0 ? void 0 : externalVisContext.attributes
            });
            if (allSuggestions.length) {
              availableSuggestionsWithType.push({
                suggestion: allSuggestions[0],
                type: _types.UnifiedHistogramSuggestionType.lensSuggestion
              });
            }
          } else {
            // appends an ES|QL histogram if available
            const histogramSuggestionForESQL = this.getHistogramSuggestionForESQL({
              queryParams,
              breakdownField,
              preferredVisAttributes: externalVisContext === null || externalVisContext === void 0 ? void 0 : externalVisContext.attributes
            });
            if (histogramSuggestionForESQL) {
              availableSuggestionsWithType.push({
                suggestion: histogramSuggestionForESQL,
                type: _types.UnifiedHistogramSuggestionType.histogramForESQL
              });
            }
          }
        }
      } else {
        // appends histogram for the data view mode
        const histogramSuggestionForDataView = this.getDefaultHistogramSuggestion({
          queryParams,
          timeInterval,
          breakdownField
        });
        if (histogramSuggestionForDataView) {
          availableSuggestionsWithType.push({
            suggestion: histogramSuggestionForDataView,
            type: _types.UnifiedHistogramSuggestionType.histogramForDataView
          });
        }
      }
      if (externalVisContext && queryParams.isPlainRecord) {
        // externalVisContext can be based on an unfamiliar suggestion (not a part of allSuggestions), but it was saved before, so we try to restore it too
        const derivedSuggestion = (0, _external_vis_context.deriveLensSuggestionFromLensAttributes)({
          externalVisContext,
          queryParams
        });
        if (derivedSuggestion) {
          availableSuggestionsWithType.push({
            suggestion: derivedSuggestion,
            type: _types.UnifiedHistogramSuggestionType.lensSuggestion
          });
        }
      }
      if (externalVisContext) {
        // try to find a suggestion that is compatible with the external vis context
        const matchingItem = availableSuggestionsWithType.find(item => (0, _external_vis_context.isSuggestionShapeAndVisContextCompatible)(item.suggestion, externalVisContext));
        if (matchingItem) {
          currentSuggestion = matchingItem.suggestion;
          type = matchingItem.type;
        }
      }
      if (!currentSuggestion && availableSuggestionsWithType.length) {
        // otherwise pick any first available suggestion
        currentSuggestion = availableSuggestionsWithType[0].suggestion;
        type = availableSuggestionsWithType[0].type;
      }
      return {
        currentSuggestionContext: {
          type: Boolean(currentSuggestion) ? type : _types.UnifiedHistogramSuggestionType.unsupported,
          suggestion: currentSuggestion
        }
      };
    });
    (0, _defineProperty2.default)(this, "getDefaultHistogramSuggestion", ({
      queryParams,
      timeInterval,
      breakdownField
    }) => {
      const {
        dataView
      } = queryParams;
      if (!dataView.isTimeBased() || !dataView.timeFieldName) {
        return undefined;
      }
      const showBreakdown = breakdownField && (0, _fieldUtils.fieldSupportsBreakdown)(breakdownField);
      let columnOrder = ['date_column', 'count_column'];
      if (showBreakdown) {
        columnOrder = ['breakdown_column', ...columnOrder];
      }
      let columns = {
        date_column: {
          dataType: 'date',
          isBucketed: true,
          label: dataView.timeFieldName,
          operationType: 'date_histogram',
          scale: 'interval',
          sourceField: dataView.timeFieldName,
          params: {
            interval: timeInterval !== null && timeInterval !== void 0 ? timeInterval : 'auto'
          }
        },
        count_column: {
          dataType: 'number',
          isBucketed: false,
          label: _i18n.i18n.translate('unifiedHistogram.countColumnLabel', {
            defaultMessage: 'Count of records'
          }),
          operationType: 'count',
          scale: 'ratio',
          sourceField: '___records___',
          params: {
            format: {
              id: 'number',
              params: {
                decimals: 0
              }
            }
          }
        }
      };
      if (showBreakdown) {
        columns = {
          ...columns,
          breakdown_column: {
            dataType: 'string',
            isBucketed: true,
            label: _i18n.i18n.translate('unifiedHistogram.breakdownColumnLabel', {
              defaultMessage: 'Top 3 values of {fieldName}',
              values: {
                fieldName: breakdownField === null || breakdownField === void 0 ? void 0 : breakdownField.displayName
              }
            }),
            operationType: 'terms',
            scale: 'ordinal',
            sourceField: breakdownField.name,
            params: {
              size: 3,
              orderBy: {
                type: 'column',
                columnId: 'count_column'
              },
              orderDirection: 'desc',
              otherBucket: true,
              missingBucket: true,
              parentFormat: {
                id: 'terms'
              }
            }
          }
        };
      }
      const datasourceState = {
        layers: {
          [UNIFIED_HISTOGRAM_LAYER_ID]: {
            columnOrder,
            columns,
            indexPatternId: dataView.id
          }
        }
      };
      const visualizationState = {
        layers: [{
          accessors: ['count_column'],
          layerId: UNIFIED_HISTOGRAM_LAYER_ID,
          layerType: 'data',
          seriesType: 'bar_stacked',
          xAccessor: 'date_column',
          ...(showBreakdown ? {
            splitAccessor: 'breakdown_column'
          } : {
            yConfig: [{
              forAccessor: 'count_column'
            }]
          })
        }],
        legend: {
          isVisible: true,
          position: 'right',
          legendSize: _public.LegendSize.EXTRA_LARGE,
          shouldTruncate: false
        },
        preferredSeriesType: 'bar_stacked',
        valueLabels: 'hide',
        fittingFunction: 'None',
        minBarHeight: 2,
        showCurrentTimeMarker: true,
        axisTitlesVisibilitySettings: {
          x: false,
          yLeft: false,
          yRight: false
        },
        gridlinesVisibilitySettings: {
          x: true,
          yLeft: true,
          yRight: false
        },
        tickLabelsVisibilitySettings: {
          x: true,
          yLeft: true,
          yRight: false
        }
      };
      return {
        visualizationId: 'lnsXY',
        visualizationState,
        datasourceState,
        datasourceId: 'formBased',
        columns: Object.keys(columns).length
      };
    });
    (0, _defineProperty2.default)(this, "getHistogramSuggestionForESQL", ({
      queryParams,
      breakdownField,
      preferredVisAttributes
    }) => {
      const {
        dataView,
        query,
        timeRange,
        columns
      } = queryParams;
      const breakdownColumn = breakdownField !== null && breakdownField !== void 0 && breakdownField.name ? columns === null || columns === void 0 ? void 0 : columns.find(column => column.name === breakdownField.name) : undefined;
      if (dataView.isTimeBased() && timeRange && (0, _esQuery.isOfAggregateQueryType)(query) && !(0, _esqlUtils.hasTransformationalCommand)(query.esql)) {
        var _this$lensSuggestions;
        const interval = (0, _visualizationUtils.computeInterval)(timeRange, this.services.data);
        const esqlQuery = this.getESQLHistogramQuery({
          dataView,
          query,
          timeRange,
          interval,
          breakdownColumn
        });
        const dateFieldLabel = `${dataView.timeFieldName} every ${interval}`;
        const context = {
          dataViewSpec: dataView === null || dataView === void 0 ? void 0 : dataView.toSpec(),
          fieldName: '',
          textBasedColumns: [{
            id: _external_vis_context.TIMESTAMP_COLUMN,
            name: dateFieldLabel,
            meta: {
              type: 'date'
            }
          }, {
            id: 'results',
            name: 'results',
            meta: {
              type: 'number'
            }
          }],
          query: {
            esql: esqlQuery
          }
        };
        if (breakdownColumn) {
          context.textBasedColumns.push(breakdownColumn);
        }

        // here the attributes contain the main query and not the histogram one
        const updatedAttributesWithQuery = preferredVisAttributes ? (0, _external_vis_context.injectESQLQueryIntoLensLayers)(preferredVisAttributes, {
          esql: esqlQuery
        }, dateFieldLabel) : undefined;
        const suggestions = (_this$lensSuggestions = this.lensSuggestionsApi(context, dataView, ['lnsDatatable'], _visualizationUtils.ChartType.XY, updatedAttributesWithQuery)) !== null && _this$lensSuggestions !== void 0 ? _this$lensSuggestions : [];
        if (suggestions.length) {
          var _breakdownColumn$meta;
          const suggestion = suggestions[0];
          const suggestionVisualizationState = Object.assign({}, suggestion === null || suggestion === void 0 ? void 0 : suggestion.visualizationState);
          // the suggestions api will suggest a numeric column as a metric and not as a breakdown,
          // so we need to adjust it here
          if (breakdownColumn && ((_breakdownColumn$meta = breakdownColumn.meta) === null || _breakdownColumn$meta === void 0 ? void 0 : _breakdownColumn$meta.type) === 'number' && suggestion && 'layers' in suggestionVisualizationState && Array.isArray(suggestionVisualizationState.layers)) {
            return {
              ...suggestion,
              visualizationState: {
                ...(suggestionVisualizationState !== null && suggestionVisualizationState !== void 0 ? suggestionVisualizationState : {}),
                layers: suggestionVisualizationState.layers.map(layer => {
                  return {
                    ...layer,
                    accessors: ['results'],
                    splitAccessor: breakdownColumn.name
                  };
                })
              }
            };
          }
          return suggestion;
        }
      }
      return undefined;
    });
    (0, _defineProperty2.default)(this, "getESQLHistogramQuery", ({
      dataView,
      timeRange,
      query,
      interval,
      breakdownColumn
    }) => {
      const queryInterval = interval !== null && interval !== void 0 ? interval : (0, _visualizationUtils.computeInterval)(timeRange, this.services.data);
      const language = (0, _esQuery.getAggregateQueryMode)(query);
      const safeQuery = (0, _esqlUtils.removeDropCommandsFromESQLQuery)(query[language]);
      const breakdown = breakdownColumn ? `, \`${breakdownColumn.name}\`` : '';

      // sort by breakdown column if it's sortable
      const sortBy = breakdownColumn && (0, _esqlUtils.isESQLColumnSortable)(breakdownColumn) ? ` | sort \`${breakdownColumn.name}\` asc` : '';
      return (0, _esqlUtils.appendToESQLQuery)(safeQuery, `| EVAL ${_external_vis_context.TIMESTAMP_COLUMN}=DATE_TRUNC(${queryInterval}, ${dataView.timeFieldName}) | stats results = count(*) by ${_external_vis_context.TIMESTAMP_COLUMN}${breakdown}${sortBy}`);
    });
    (0, _defineProperty2.default)(this, "getAllSuggestions", ({
      queryParams,
      preferredVisAttributes
    }) => {
      var _this$lensSuggestions2;
      const {
        dataView,
        columns,
        query,
        isPlainRecord
      } = queryParams;
      if (!isPlainRecord || !(0, _esQuery.isOfAggregateQueryType)(query)) {
        return [];
      }
      const preferredChartType = preferredVisAttributes ? (0, _visualizationUtils.mapVisToChartType)(preferredVisAttributes.visualizationType) : undefined;
      let visAttributes = preferredVisAttributes;
      if (preferredVisAttributes) {
        visAttributes = (0, _external_vis_context.injectESQLQueryIntoLensLayers)(preferredVisAttributes, query);
      }
      const context = {
        dataViewSpec: dataView === null || dataView === void 0 ? void 0 : dataView.toSpec(),
        fieldName: '',
        textBasedColumns: columns,
        query: query && (0, _esQuery.isOfAggregateQueryType)(query) ? query : undefined
      };
      return (_this$lensSuggestions2 = this.lensSuggestionsApi(context, dataView, ['lnsDatatable'], preferredChartType, visAttributes)) !== null && _this$lensSuggestions2 !== void 0 ? _this$lensSuggestions2 : [];
    });
    (0, _defineProperty2.default)(this, "getLensAttributesState", ({
      currentSuggestionContext,
      externalVisContext,
      queryParams,
      timeInterval,
      breakdownField,
      table,
      getModifiedVisAttributes
    }) => {
      var _visContext;
      const {
        dataView,
        query,
        filters,
        timeRange,
        columns
      } = queryParams;
      const {
        type: suggestionType,
        suggestion
      } = currentSuggestionContext;
      if (!suggestion || !suggestion.datasourceId || !query || !filters) {
        return {
          externalVisContextStatus: _types.UnifiedHistogramExternalVisContextStatus.unknown,
          visContext: undefined
        };
      }
      const isTextBased = (0, _esQuery.isOfAggregateQueryType)(query);
      const requestData = {
        dataViewId: dataView.id,
        timeField: dataView.timeFieldName,
        timeInterval: isTextBased ? undefined : timeInterval,
        breakdownField: breakdownField === null || breakdownField === void 0 ? void 0 : breakdownField.name
      };
      const currentQuery = suggestionType === _types.UnifiedHistogramSuggestionType.histogramForESQL && isTextBased && timeRange ? {
        esql: this.getESQLHistogramQuery({
          dataView,
          query,
          timeRange,
          breakdownColumn: breakdownField !== null && breakdownField !== void 0 && breakdownField.name ? columns === null || columns === void 0 ? void 0 : columns.find(column => column.name === breakdownField.name) : undefined
        })
      } : query;
      let externalVisContextStatus;
      let visContext;
      if (externalVisContext !== null && externalVisContext !== void 0 && externalVisContext.attributes) {
        var _externalVisContext$a, _externalVisContext$a2;
        if ((0, _lodash.isEqual)(currentQuery, (_externalVisContext$a = externalVisContext.attributes) === null || _externalVisContext$a === void 0 ? void 0 : (_externalVisContext$a2 = _externalVisContext$a.state) === null || _externalVisContext$a2 === void 0 ? void 0 : _externalVisContext$a2.query) && areSuggestionAndVisContextAndQueryParamsStillCompatible({
          suggestionType,
          suggestion,
          externalVisContext,
          queryParams,
          requestData
        })) {
          // using the external lens attributes
          visContext = externalVisContext;
          externalVisContextStatus = _types.UnifiedHistogramExternalVisContextStatus.applied;
        } else {
          // external vis is not compatible with the current suggestion
          externalVisContextStatus = _types.UnifiedHistogramExternalVisContextStatus.automaticallyOverridden;
        }
      } else {
        externalVisContextStatus = _types.UnifiedHistogramExternalVisContextStatus.automaticallyCreated;
      }
      if (!visContext) {
        const attributes = (0, _visualizationUtils.getLensAttributesFromSuggestion)({
          query: currentQuery,
          filters,
          suggestion,
          dataView
        });
        if (suggestionType === _types.UnifiedHistogramSuggestionType.histogramForDataView) {
          var _dataView$id;
          attributes.title = _i18n.i18n.translate('unifiedHistogram.lensTitle', {
            defaultMessage: 'Edit visualization'
          });
          attributes.references = [{
            id: (_dataView$id = dataView.id) !== null && _dataView$id !== void 0 ? _dataView$id : '',
            name: `indexpattern-datasource-layer-${UNIFIED_HISTOGRAM_LAYER_ID}`,
            type: 'index-pattern'
          }];
        }
        visContext = {
          attributes,
          requestData,
          suggestionType
        };
      }
      if (table &&
      // already fetched data
      query && isTextBased && suggestionType === _types.UnifiedHistogramSuggestionType.lensSuggestion && (_visContext = visContext) !== null && _visContext !== void 0 && _visContext.attributes) {
        visContext = {
          ...visContext,
          attributes: (0, _lens_vis_from_table.enrichLensAttributesWithTablesData)({
            attributes: visContext.attributes,
            table
          })
        };
      }
      if (externalVisContextStatus !== _types.UnifiedHistogramExternalVisContextStatus.applied && getModifiedVisAttributes) {
        visContext.attributes = getModifiedVisAttributes(visContext.attributes);
      }
      return {
        externalVisContextStatus,
        visContext
      };
    });
    this.services = services;
    this.lensSuggestionsApi = lensSuggestionsApi;
    this.state$ = new _rxjs.BehaviorSubject({
      status: LensVisServiceStatus.initial,
      currentSuggestionContext: {
        suggestion: undefined,
        type: _types.UnifiedHistogramSuggestionType.unsupported
      },
      visContext: undefined
    });
    const stateSelector = stateSelectorFactory(this.state$);
    this.status$ = stateSelector(state => state.status);
    this.currentSuggestionContext$ = stateSelector(state => state.currentSuggestionContext, _lodash.isEqual);
    this.visContext$ = stateSelector(state => state.visContext, _lodash.isEqual);
    this.prevUpdateContext = undefined;
  }
}
exports.LensVisService = LensVisService;
function areSuggestionAndVisContextAndQueryParamsStillCompatible({
  suggestionType,
  suggestion,
  externalVisContext,
  queryParams,
  requestData
}) {
  // requestData should match
  if (Object.keys(requestData).some(key => !(0, _lodash.isEqual)(requestData[key], externalVisContext.requestData[key]))) {
    return false;
  }
  if (queryParams.isPlainRecord && suggestionType === _types.UnifiedHistogramSuggestionType.lensSuggestion && !(0, _external_vis_context.deriveLensSuggestionFromLensAttributes)({
    externalVisContext,
    queryParams
  })) {
    // can't retrieve back a suggestion with matching query and known columns
    return false;
  }
  return suggestionType === externalVisContext.suggestionType &&
  // vis shape should match
  (0, _external_vis_context.isSuggestionShapeAndVisContextCompatible)(suggestion, externalVisContext);
}