"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getCommonFieldConfiguration = void 0;
var _discoverUtils = require("@kbn/discover-utils");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
var _service_name_link = require("../components/service_name_link");
var _trace_id_link = require("../components/trace_id_link");
var _timestamp = require("../components/timestamp");
var _http_status_code = require("../components/http_status_code");
var _transaction_name_link = require("../components/transaction_name_link");
var _highlight_field = require("../components/highlight_field.tsx");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const getCommonFieldConfiguration = ({
  attributes,
  flattenedDoc
}) => {
  return {
    [_discoverUtils.TRANSACTION_NAME_FIELD]: {
      title: _i18n.i18n.translate('unifiedDocViewer.observability.traces.details.transactionName.title', {
        defaultMessage: 'Transaction name'
      }),
      content: (value, formattedValue) => /*#__PURE__*/_react.default.createElement(_highlight_field.HighlightField, {
        value: value,
        formattedValue: formattedValue
      }, ({
        content
      }) => /*#__PURE__*/_react.default.createElement(_transaction_name_link.TransactionNameLink, {
        serviceName: flattenedDoc[_discoverUtils.SERVICE_NAME_FIELD],
        transactionName: value,
        renderContent: () => content
      })),
      value: flattenedDoc[_discoverUtils.TRANSACTION_NAME_FIELD],
      formattedValue: attributes[_discoverUtils.TRANSACTION_NAME_FIELD]
    },
    [_discoverUtils.SERVICE_NAME_FIELD]: {
      title: _i18n.i18n.translate('unifiedDocViewer.observability.traces.details.service.title', {
        defaultMessage: 'Service'
      }),
      content: (value, formattedValue) => /*#__PURE__*/_react.default.createElement(_highlight_field.HighlightField, {
        value: value,
        formattedValue: formattedValue
      }, ({
        content
      }) => /*#__PURE__*/_react.default.createElement(_service_name_link.ServiceNameLink, {
        serviceName: value,
        agentName: flattenedDoc[_discoverUtils.AGENT_NAME_FIELD],
        formattedServiceName: content
      })),
      value: flattenedDoc[_discoverUtils.SERVICE_NAME_FIELD],
      formattedValue: attributes[_discoverUtils.SERVICE_NAME_FIELD]
    },
    [_discoverUtils.TRACE_ID_FIELD]: {
      title: _i18n.i18n.translate('unifiedDocViewer.observability.traces.details.traceId.title', {
        defaultMessage: 'Trace ID'
      }),
      content: (value, formattedValue) => /*#__PURE__*/_react.default.createElement(_highlight_field.HighlightField, {
        value: value,
        formattedValue: formattedValue
      }, ({
        content
      }) => /*#__PURE__*/_react.default.createElement(_trace_id_link.TraceIdLink, {
        traceId: value,
        formattedTraceId: content
      })),
      value: flattenedDoc[_discoverUtils.TRACE_ID_FIELD],
      formattedValue: attributes[_discoverUtils.TRACE_ID_FIELD]
    },
    [_discoverUtils.TIMESTAMP_FIELD]: {
      title: _i18n.i18n.translate('unifiedDocViewer.observability.traces.details.timestamp.title', {
        defaultMessage: 'Start time'
      }),
      content: value => /*#__PURE__*/_react.default.createElement(_timestamp.Timestamp, {
        timestamp: value
      }),
      value: flattenedDoc[_discoverUtils.TIMESTAMP_FIELD]
    },
    [_discoverUtils.HTTP_RESPONSE_STATUS_CODE_FIELD]: {
      title: _i18n.i18n.translate('unifiedDocViewer.observability.traces.details.httpResponseStatusCode.title', {
        defaultMessage: 'Status code'
      }),
      content: value => /*#__PURE__*/_react.default.createElement(_http_status_code.HttpStatusCode, {
        code: value
      }),
      value: flattenedDoc[_discoverUtils.HTTP_RESPONSE_STATUS_CODE_FIELD]
    }
  };
};
exports.getCommonFieldConfiguration = getCommonFieldConfiguration;