"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getTransactionDistributionChartData = getTransactionDistributionChartData;
exports.useTransactionLatencyChart = void 0;
var _i18n = require("@kbn/i18n");
var _react = require("react");
var _eui = require("@elastic/eui");
var _reactHooks = require("@kbn/react-hooks");
var _plugin = require("../../../../../../plugin");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

function getTransactionDistributionChartData({
  euiTheme,
  transactionHistogram
}) {
  const transactionDistributionChartData = [];
  if (Array.isArray(transactionHistogram)) {
    transactionDistributionChartData.push({
      id: _i18n.i18n.translate('unifiedDocViewer.observability.traces.useTransactionLatencyChart.allTransactionsLabel', {
        defaultMessage: 'All transactions'
      }),
      histogram: transactionHistogram,
      areaSeriesColor: euiTheme.colors.vis.euiColorVis1
    });
  }
  return transactionDistributionChartData;
}
const getTransactionLatencyChart = ({
  core,
  signal,
  transactionName,
  transactionType,
  serviceName
}) => {
  const {
    data
  } = (0, _plugin.getUnifiedDocViewerServices)();
  const timeFilter = data.query.timefilter.timefilter.getAbsoluteTime();
  return core.http.post('/internal/apm/latency/overall_distribution/transactions', {
    body: JSON.stringify({
      transactionName,
      transactionType,
      serviceName,
      chartType: 'transactionLatency',
      end: timeFilter.to,
      environment: 'ENVIRONMENT_ALL',
      kuery: '',
      percentileThreshold: 95,
      start: timeFilter.from
    }),
    signal
  });
};
const useTransactionLatencyChart = ({
  transactionName,
  transactionType,
  serviceName
}) => {
  const {
    core
  } = (0, _plugin.getUnifiedDocViewerServices)();
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const {
    loading,
    value,
    error
  } = (0, _reactHooks.useAbortableAsync)(async ({
    signal
  }) => {
    if (!transactionName || !transactionType || !serviceName) {
      return null;
    }
    const result = await getTransactionLatencyChart({
      core,
      signal,
      transactionName,
      transactionType,
      serviceName
    });
    return {
      transactionDistributionChartData: getTransactionDistributionChartData({
        euiTheme,
        transactionHistogram: result.overallHistogram
      }),
      percentileThresholdValue: result.percentileThresholdValue
    };
  }, [core, euiTheme, serviceName, transactionName, transactionType]);
  (0, _react.useEffect)(() => {
    if (error) {
      core.notifications.toasts.addDanger({
        title: _i18n.i18n.translate('unifiedDocViewer.observability.traces.useTransactionLatencyChart.error', {
          defaultMessage: 'An error occurred while fetching the latency histogram'
        }),
        text: error.message
      });
    }
  }, [error, core]);
  return {
    loading,
    hasError: !!error,
    data: value
  };
};
exports.useTransactionLatencyChart = useTransactionLatencyChart;