"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getSpanFieldConfiguration = void 0;
var _eui = require("@elastic/eui");
var _discoverUtils = require("@kbn/discover-utils");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
var _highlight_field = require("../../components/highlight_field.tsx");
var _get_field_configuration = require("../../resources/get_field_configuration");
var _dependency_name_link = require("../sub_components/dependency_name_link");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const getSpanFieldConfiguration = ({
  attributes,
  flattenedDoc
}) => {
  return {
    ...(0, _get_field_configuration.getCommonFieldConfiguration)({
      attributes,
      flattenedDoc
    }),
    [_discoverUtils.SPAN_NAME_FIELD]: {
      title: _i18n.i18n.translate('unifiedDocViewer.observability.traces.details.spanName.title', {
        defaultMessage: 'Span name'
      }),
      content: (value, formattedValue) => /*#__PURE__*/_react.default.createElement(_highlight_field.HighlightField, {
        value: value,
        formattedValue: formattedValue
      }),
      value: flattenedDoc[_discoverUtils.SPAN_NAME_FIELD],
      formattedValue: attributes[_discoverUtils.SPAN_NAME_FIELD]
    },
    [_discoverUtils.SPAN_DESTINATION_SERVICE_RESOURCE_FIELD]: {
      title: _i18n.i18n.translate('unifiedDocViewer.observability.traces.details.spanDestinationServiceResource.title', {
        defaultMessage: 'Dependency'
      }),
      content: (value, formattedValue) => /*#__PURE__*/_react.default.createElement(_highlight_field.HighlightField, {
        value: value,
        formattedValue: formattedValue
      }, ({
        content
      }) => /*#__PURE__*/_react.default.createElement(_dependency_name_link.DependencyNameLink, {
        dependencyName: value,
        environment: flattenedDoc[_discoverUtils.SERVICE_ENVIRONMENT_FIELD],
        formattedDependencyName: content
      })),
      value: flattenedDoc[_discoverUtils.SPAN_DESTINATION_SERVICE_RESOURCE_FIELD],
      formattedValue: attributes[_discoverUtils.SPAN_DESTINATION_SERVICE_RESOURCE_FIELD],
      fieldMetadata: {
        flat_name: 'span.destination.service.resource',
        short: _i18n.i18n.translate('unifiedDocViewer.observability.traces.details.spanDestinationServiceResource.description', {
          defaultMessage: 'Identifier for the destination service resource being operated on.'
        })
      }
    },
    [_discoverUtils.SPAN_TYPE_FIELD]: {
      title: _i18n.i18n.translate('unifiedDocViewer.observability.traces.details.spanType.title', {
        defaultMessage: 'Type'
      }),
      content: (value, formattedValue) => /*#__PURE__*/_react.default.createElement(_highlight_field.HighlightField, {
        value: value,
        formattedValue: formattedValue
      }, ({
        content
      }) => /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
        color: "hollow"
      }, content)),
      value: flattenedDoc[_discoverUtils.SPAN_TYPE_FIELD],
      formattedValue: attributes[_discoverUtils.SPAN_TYPE_FIELD]
    },
    [_discoverUtils.SPAN_SUBTYPE_FIELD]: {
      title: _i18n.i18n.translate('unifiedDocViewer.observability.traces.details.spanSubtype.title', {
        defaultMessage: 'Subtype'
      }),
      content: (value, formattedValue) => /*#__PURE__*/_react.default.createElement(_highlight_field.HighlightField, {
        value: value,
        formattedValue: formattedValue
      }, ({
        content
      }) => /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
        color: "hollow"
      }, content)),
      value: flattenedDoc[_discoverUtils.SPAN_SUBTYPE_FIELD],
      formattedValue: attributes[_discoverUtils.SPAN_SUBTYPE_FIELD]
    }
  };
};
exports.getSpanFieldConfiguration = getSpanFieldConfiguration;