"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.isSpanHit = void 0;
var _discoverUtils = require("@kbn/discover-utils");
var _get_flattened_fields = require("@kbn/discover-utils/src/utils/get_flattened_fields");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const isSpanHit = hit => {
  if (!(hit !== null && hit !== void 0 && hit.flattened)) {
    return false;
  }
  const processorEvent = (0, _get_flattened_fields.getFlattenedFields)(hit, [_discoverUtils.PROCESSOR_EVENT_FIELD])[_discoverUtils.PROCESSOR_EVENT_FIELD];
  const isOtelSpan = processorEvent == null;
  const isApmSpan = processorEvent === 'span';
  return isApmSpan || isOtelSpan;
};
exports.isSpanHit = isSpanHit;