"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FieldWithActions = FieldWithActions;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _field_hover_popover_action = require("./field_hover_popover_action");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

function FieldWithActions({
  field,
  fieldMetadata,
  fieldMapping,
  formattedValue,
  label,
  value,
  loading,
  children,
  showActions = true,
  ...props
}) {
  const hasFieldDescription = !!(fieldMetadata !== null && fieldMetadata !== void 0 && fieldMetadata.flat_name);
  if (!label) {
    return null;
  }
  const fieldContent = /*#__PURE__*/_react.default.createElement("div", {
    className: "eui-textBreakWord"
  }, loading && /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
    size: "m"
  }), children);
  return /*#__PURE__*/_react.default.createElement("div", props, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 1
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "xs"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xxxs"
  }, /*#__PURE__*/_react.default.createElement("h3", null, label))), hasFieldDescription && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
    title: fieldMetadata.flat_name,
    content: fieldMetadata.short,
    color: "subdued",
    "aria-label": `${fieldMetadata.flat_name}: ${fieldMetadata.short}`
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 2
  }, showActions ? /*#__PURE__*/_react.default.createElement(_field_hover_popover_action.FieldHoverActionPopover, {
    title: value,
    value: value,
    field: field,
    fieldMapping: fieldMapping
  }, fieldContent) : fieldContent)));
}