"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LogsOverview = void 0;
var _react = _interopRequireWildcard(require("react"));
var _discoverUtils = require("@kbn/discover-utils");
var _eui = require("@elastic/eui");
var _src = require("@kbn/discover-utils/src");
var _logs_overview_header = require("./logs_overview_header");
var _logs_overview_highlights = require("./logs_overview_highlights");
var _use_field_actions = require("../../hooks/use_field_actions");
var _plugin = require("../../plugin");
var _logs_overview_degraded_fields = require("./logs_overview_degraded_fields");
var _logs_overview_stacktrace_section = require("./logs_overview_stacktrace_section");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const LogsOverview = exports.LogsOverview = /*#__PURE__*/(0, _react.forwardRef)(({
  columns,
  dataView,
  hit,
  filter,
  onAddColumn,
  onRemoveColumn,
  renderAIAssistant,
  renderStreamsField
}, ref) => {
  const {
    fieldFormats
  } = (0, _plugin.getUnifiedDocViewerServices)();
  const parsedDoc = (0, _discoverUtils.getLogDocumentOverview)(hit, {
    dataView,
    fieldFormats
  });
  const LogsOverviewAIAssistant = renderAIAssistant;
  const stacktraceFields = (0, _src.getStacktraceFields)(hit);
  const isStacktraceAvailable = Object.values(stacktraceFields).some(Boolean);
  const qualityIssuesSectionRef = (0, _react.useRef)(null);
  const stackTraceSectionRef = (0, _react.useRef)(null);
  (0, _react.useImperativeHandle)(ref, () => ({
    openAndScrollToSection: section => {
      if (section === 'quality_issues') {
        var _qualityIssuesSection;
        (_qualityIssuesSection = qualityIssuesSectionRef.current) === null || _qualityIssuesSection === void 0 ? void 0 : _qualityIssuesSection.openAndScrollToSection();
      } else if (section === 'stacktrace') {
        var _stackTraceSectionRef;
        (_stackTraceSectionRef = stackTraceSectionRef.current) === null || _stackTraceSectionRef === void 0 ? void 0 : _stackTraceSectionRef.openAndScrollToSection();
      }
    }
  }), []);
  return /*#__PURE__*/_react.default.createElement(_use_field_actions.FieldActionsProvider, {
    columns: columns,
    filter: filter,
    onAddColumn: onAddColumn,
    onRemoveColumn: onRemoveColumn
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_logs_overview_header.LogsOverviewHeader, {
    formattedDoc: parsedDoc,
    doc: hit
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "xs"
  }), /*#__PURE__*/_react.default.createElement(_logs_overview_highlights.LogsOverviewHighlights, {
    formattedDoc: parsedDoc,
    doc: hit,
    renderStreamsField: renderStreamsField
  }), /*#__PURE__*/_react.default.createElement(_logs_overview_degraded_fields.LogsOverviewDegradedFields, {
    ref: qualityIssuesSectionRef,
    rawDoc: hit.raw
  }), isStacktraceAvailable && /*#__PURE__*/_react.default.createElement(_logs_overview_stacktrace_section.LogsOverviewStacktraceSection, {
    ref: stackTraceSectionRef,
    hit: hit,
    dataView: dataView
  }), LogsOverviewAIAssistant && /*#__PURE__*/_react.default.createElement(LogsOverviewAIAssistant, {
    doc: hit
  }));
});