"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CloningNotification = void 0;
var _eui = require("@elastic/eui");
var React = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const txtDismiss = _i18n.i18n.translate('uiActionsEnhanced.drilldowns.containers.drilldownList.copyingNotification.dismiss', {
  defaultMessage: 'Dismiss',
  description: 'Dismiss button in cloning notification callout.'
});
const txtBody = count => _i18n.i18n.translate('uiActionsEnhanced.drilldowns.containers.drilldownList.copyingNotification.body', {
  defaultMessage: '{count, number} {count, plural, one {drilldown} other {drilldowns}} copied.',
  description: 'Title of notification show when one or more drilldowns were copied.',
  values: {
    count
  }
});
const CloningNotification = ({
  count = 1
}) => {
  const [dismissed, setDismissed] = React.useState(false);
  if (dismissed) return null;
  const title = /*#__PURE__*/React.createElement(React.Fragment, null, txtBody(count), " ", /*#__PURE__*/React.createElement(_eui.EuiLink, {
    onClick: () => setDismissed(true)
  }, txtDismiss));
  return /*#__PURE__*/React.createElement(React.Fragment, null, /*#__PURE__*/React.createElement(_eui.EuiCallOut, {
    title: title,
    color: "success",
    size: "s",
    iconType: "check"
  }), /*#__PURE__*/React.createElement(_eui.EuiSpacer, null));
};
exports.CloningNotification = CloningNotification;