"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useRulesListFilterStore = exports.convertRulesListFiltersToFilterAttributes = void 0;
var _reactRouterDom = require("react-router-dom");
var _public = require("@kbn/kibana-utils-plugin/public");
var _react = require("react");
var _useLocalStorage = _interopRequireDefault(require("react-use/lib/useLocalStorage"));
var _lodash = require("lodash");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const RULES_LIST_FILTERS_KEY = 'triggersActionsUi_rulesList';
const convertRulesListFiltersToFilterAttributes = rulesListFilter => {
  return {
    actionTypes: rulesListFilter.actionTypes,
    lastResponse: rulesListFilter.ruleLastRunOutcomes,
    params: rulesListFilter.ruleParams,
    search: rulesListFilter.searchText,
    status: rulesListFilter.ruleStatuses,
    tags: rulesListFilter.tags,
    type: rulesListFilter.types
  };
};
exports.convertRulesListFiltersToFilterAttributes = convertRulesListFiltersToFilterAttributes;
const useRulesListFilterStore = ({
  lastResponseFilter,
  lastRunOutcomeFilter,
  rulesListKey = RULES_LIST_FILTERS_KEY,
  ruleParamFilter,
  statusFilter,
  searchFilter,
  typeFilter
}) => {
  var _filtersStore$actionT, _ref, _filtersStore$lastRes, _ref2, _filtersStore$params, _ref3, _filtersStore$status, _ref4, _filtersStore$search, _filtersStore$tags, _ref5, _filtersStore$type;
  const history = (0, _reactRouterDom.useHistory)();
  const urlStateStorage = (0, _public.createKbnUrlStateStorage)({
    history,
    useHash: false,
    useHashQuery: false
  });
  const [rulesListFilterLocal, setRulesListFilterLocal] = (0, _useLocalStorage.default)(`${RULES_LIST_FILTERS_KEY}_filters`, {});
  const hasFilterFromLocalStorage = (0, _react.useMemo)(() => rulesListFilterLocal ? !Object.values(rulesListFilterLocal).every(filters => (0, _lodash.isEmpty)(filters)) : false, [rulesListFilterLocal]);
  const rulesListFilterUrl = (0, _react.useMemo)(() => {
    var _urlStateStorage$get;
    return (_urlStateStorage$get = urlStateStorage.get('_a')) !== null && _urlStateStorage$get !== void 0 ? _urlStateStorage$get : {};
  }, [urlStateStorage]);
  const hasFilterFromUrl = (0, _react.useMemo)(() => rulesListFilterUrl ? !Object.values(rulesListFilterUrl).every(filters => (0, _lodash.isEmpty)(filters)) : false, [rulesListFilterUrl]);
  const filtersStore = (0, _react.useMemo)(() => hasFilterFromUrl ? rulesListFilterUrl : hasFilterFromLocalStorage ? rulesListFilterLocal : {}, [hasFilterFromLocalStorage, hasFilterFromUrl, rulesListFilterLocal, rulesListFilterUrl]);
  const [filters, setFilters] = (0, _react.useState)({
    actionTypes: (_filtersStore$actionT = filtersStore === null || filtersStore === void 0 ? void 0 : filtersStore.actionTypes) !== null && _filtersStore$actionT !== void 0 ? _filtersStore$actionT : [],
    ruleExecutionStatuses: lastResponseFilter !== null && lastResponseFilter !== void 0 ? lastResponseFilter : [],
    ruleLastRunOutcomes: (_ref = (_filtersStore$lastRes = filtersStore === null || filtersStore === void 0 ? void 0 : filtersStore.lastResponse) !== null && _filtersStore$lastRes !== void 0 ? _filtersStore$lastRes : lastRunOutcomeFilter) !== null && _ref !== void 0 ? _ref : [],
    ruleParams: (_ref2 = (_filtersStore$params = filtersStore === null || filtersStore === void 0 ? void 0 : filtersStore.params) !== null && _filtersStore$params !== void 0 ? _filtersStore$params : ruleParamFilter) !== null && _ref2 !== void 0 ? _ref2 : {},
    ruleStatuses: (_ref3 = (_filtersStore$status = filtersStore === null || filtersStore === void 0 ? void 0 : filtersStore.status) !== null && _filtersStore$status !== void 0 ? _filtersStore$status : statusFilter) !== null && _ref3 !== void 0 ? _ref3 : [],
    searchText: (_ref4 = (_filtersStore$search = filtersStore === null || filtersStore === void 0 ? void 0 : filtersStore.search) !== null && _filtersStore$search !== void 0 ? _filtersStore$search : searchFilter) !== null && _ref4 !== void 0 ? _ref4 : '',
    tags: (_filtersStore$tags = filtersStore === null || filtersStore === void 0 ? void 0 : filtersStore.tags) !== null && _filtersStore$tags !== void 0 ? _filtersStore$tags : [],
    types: (_ref5 = (_filtersStore$type = filtersStore === null || filtersStore === void 0 ? void 0 : filtersStore.type) !== null && _filtersStore$type !== void 0 ? _filtersStore$type : typeFilter) !== null && _ref5 !== void 0 ? _ref5 : [],
    kueryNode: undefined
  });
  const updateUrlFilters = (0, _react.useCallback)(updatedParams => {
    urlStateStorage.set('_a', convertRulesListFiltersToFilterAttributes(updatedParams));
  }, [urlStateStorage]);
  const updateLocalFilters = (0, _react.useCallback)(updatedParams => {
    setRulesListFilterLocal(convertRulesListFiltersToFilterAttributes(updatedParams));
  }, [setRulesListFilterLocal]);
  const setFiltersStore = (0, _react.useCallback)(updateFiltersProps => {
    const {
      filter,
      value
    } = updateFiltersProps;
    setFilters(prev => {
      const newFilters = {
        ...prev,
        [filter]: value
      };
      updateUrlFilters(newFilters);
      updateLocalFilters(newFilters);
      return newFilters;
    });
  }, [updateLocalFilters, updateUrlFilters]);
  const resetFiltersStore = (0, _react.useCallback)(() => {
    const resetFilter = {
      actionTypes: [],
      ruleExecutionStatuses: [],
      ruleLastRunOutcomes: [],
      ruleParams: {},
      ruleStatuses: [],
      searchText: '',
      tags: [],
      types: [],
      kueryNode: undefined
    };
    setFilters(resetFilter);
    updateUrlFilters(resetFilter);
    updateLocalFilters(resetFilter);
  }, [updateLocalFilters, updateUrlFilters]);
  (0, _react.useEffect)(() => {
    if (hasFilterFromUrl || hasFilterFromLocalStorage) {
      var _filtersStore$actionT2, _ref6, _filtersStore$lastRes2, _ref7, _filtersStore$params2, _ref8, _filtersStore$status2, _ref9, _filtersStore$search2, _filtersStore$tags2, _ref10, _filtersStore$type2;
      setFilters({
        actionTypes: (_filtersStore$actionT2 = filtersStore === null || filtersStore === void 0 ? void 0 : filtersStore.actionTypes) !== null && _filtersStore$actionT2 !== void 0 ? _filtersStore$actionT2 : [],
        ruleExecutionStatuses: lastResponseFilter !== null && lastResponseFilter !== void 0 ? lastResponseFilter : [],
        ruleLastRunOutcomes: (_ref6 = (_filtersStore$lastRes2 = filtersStore === null || filtersStore === void 0 ? void 0 : filtersStore.lastResponse) !== null && _filtersStore$lastRes2 !== void 0 ? _filtersStore$lastRes2 : lastRunOutcomeFilter) !== null && _ref6 !== void 0 ? _ref6 : [],
        ruleParams: (_ref7 = (_filtersStore$params2 = filtersStore === null || filtersStore === void 0 ? void 0 : filtersStore.params) !== null && _filtersStore$params2 !== void 0 ? _filtersStore$params2 : ruleParamFilter) !== null && _ref7 !== void 0 ? _ref7 : {},
        ruleStatuses: (_ref8 = (_filtersStore$status2 = filtersStore === null || filtersStore === void 0 ? void 0 : filtersStore.status) !== null && _filtersStore$status2 !== void 0 ? _filtersStore$status2 : statusFilter) !== null && _ref8 !== void 0 ? _ref8 : [],
        searchText: (_ref9 = (_filtersStore$search2 = filtersStore === null || filtersStore === void 0 ? void 0 : filtersStore.search) !== null && _filtersStore$search2 !== void 0 ? _filtersStore$search2 : searchFilter) !== null && _ref9 !== void 0 ? _ref9 : '',
        tags: (_filtersStore$tags2 = filtersStore === null || filtersStore === void 0 ? void 0 : filtersStore.tags) !== null && _filtersStore$tags2 !== void 0 ? _filtersStore$tags2 : [],
        types: (_ref10 = (_filtersStore$type2 = filtersStore === null || filtersStore === void 0 ? void 0 : filtersStore.type) !== null && _filtersStore$type2 !== void 0 ? _filtersStore$type2 : typeFilter) !== null && _ref10 !== void 0 ? _ref10 : [],
        kueryNode: undefined
      });
    }
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, []);
  return (0, _react.useMemo)(() => ({
    filters,
    setFiltersStore,
    numberOfFiltersStore: Object.values(filters).filter(filter => !(0, _lodash.isEmpty)(filter)).length,
    resetFiltersStore
  }), [filters, resetFiltersStore, setFiltersStore]);
};
exports.useRulesListFilterStore = useRulesListFilterStore;