"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.RuleFormRoute = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _responseOpsRuleForm = require("@kbn/response-ops-rule-form");
var _ruleDataUtils = require("@kbn/rule-data-utils");
var _reactRouterDom = require("react-router-dom");
var _kibana = require("../../../common/lib/kibana");
var _breadcrumb = require("../../lib/breadcrumb");
var _doc_title = require("../../lib/doc_title");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const RuleFormRoute = () => {
  const {
    http,
    application,
    notifications,
    charts,
    settings,
    data,
    dataViews,
    unifiedSearch,
    docLinks,
    ruleTypeRegistry,
    actionTypeRegistry,
    contentManagement,
    chrome,
    setBreadcrumbs,
    ...startServices
  } = (0, _kibana.useKibana)().services;
  const location = (0, _reactRouterDom.useLocation)();
  const {
    id,
    ruleTypeId
  } = (0, _reactRouterDom.useParams)();
  const {
    returnApp,
    returnPath
  } = location.state || {};

  // Set breadcrumb and page title
  (0, _react.useEffect)(() => {
    if (id) {
      setBreadcrumbs([(0, _breadcrumb.getAlertingSectionBreadcrumb)('rules', true), (0, _breadcrumb.getAlertingSectionBreadcrumb)('editRule')]);
      chrome.docTitle.change((0, _doc_title.getCurrentDocTitle)('editRule'));
    }
    if (ruleTypeId) {
      setBreadcrumbs([(0, _breadcrumb.getAlertingSectionBreadcrumb)('rules', true), (0, _breadcrumb.getAlertingSectionBreadcrumb)('createRule')]);
      chrome.docTitle.change((0, _doc_title.getCurrentDocTitle)('createRule'));
    }
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, []);
  return /*#__PURE__*/_react.default.createElement(_i18nReact.__IntlProvider, {
    locale: "en"
  }, /*#__PURE__*/_react.default.createElement(_responseOpsRuleForm.RuleForm, {
    plugins: {
      http,
      application,
      notifications,
      charts,
      settings,
      data,
      dataViews,
      unifiedSearch,
      docLinks,
      ruleTypeRegistry,
      actionTypeRegistry,
      contentManagement,
      ...startServices
    },
    id: id,
    ruleTypeId: ruleTypeId,
    onCancel: () => {
      if (returnApp && returnPath) {
        application.navigateToApp(returnApp, {
          path: returnPath
        });
      } else {
        application.navigateToApp('management', {
          path: `insightsAndAlerting/triggersActions/rules`
        });
      }
    },
    onSubmit: ruleId => {
      application.navigateToApp('management', {
        path: `insightsAndAlerting/triggersActions/${(0, _ruleDataUtils.getRuleDetailsRoute)(ruleId)}`
      });
    }
  }));
};

// eslint-disable-next-line import/no-default-export
exports.default = exports.RuleFormRoute = RuleFormRoute;