"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RuleActions = RuleActions;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _responseOpsRuleForm = require("@kbn/response-ops-rule-form");
var _ = require("../../../..");
var _use_fetch_rule_action_connectors = require("../../../hooks/use_fetch_rule_action_connectors");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function RuleActions({
  ruleActions,
  actionTypeRegistry,
  legacyNotifyWhen
}) {
  const {
    isLoadingActionConnectors,
    actionConnectors
  } = (0, _use_fetch_rule_action_connectors.useFetchRuleActionConnectors)({
    ruleActions
  });
  const hasConnectors = actionConnectors && actionConnectors.length > 0;
  const hasActions = ruleActions && ruleActions.length > 0;
  if (!hasConnectors || !hasActions) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s"
    }, _i18n.i18n.translate('xpack.triggersActionsUI.ruleDetails.noActions', {
      defaultMessage: 'No actions'
    })));
  }
  const getNotifyText = (action, isSystemAction) => {
    if (isSystemAction) {
      return _responseOpsRuleForm.NOTIFY_WHEN_OPTIONS[1].value.inputDisplay;
    }
    if ('frequency' in action) {
      var _ref, _ref2, _notifyWhen$value$inp, _action$frequency2;
      const notifyWhen = _responseOpsRuleForm.NOTIFY_WHEN_OPTIONS.find(options => {
        var _action$frequency;
        return options.value.value === ((_action$frequency = action.frequency) === null || _action$frequency === void 0 ? void 0 : _action$frequency.notifyWhen);
      });
      return (_ref = (_ref2 = (_notifyWhen$value$inp = notifyWhen === null || notifyWhen === void 0 ? void 0 : notifyWhen.value.inputDisplay) !== null && _notifyWhen$value$inp !== void 0 ? _notifyWhen$value$inp : (_action$frequency2 = action.frequency) === null || _action$frequency2 === void 0 ? void 0 : _action$frequency2.notifyWhen) !== null && _ref2 !== void 0 ? _ref2 : legacyNotifyWhen) !== null && _ref !== void 0 ? _ref : '';
    }
    return '';
  };
  const getActionIconClass = actionGroupId => {
    const actionGroup = actionTypeRegistry.list().find(group => group.id === actionGroupId);
    return typeof (actionGroup === null || actionGroup === void 0 ? void 0 : actionGroup.iconClass) === 'string' ? actionGroup === null || actionGroup === void 0 ? void 0 : actionGroup.iconClass : (0, _.suspendedComponentWithProps)(actionGroup === null || actionGroup === void 0 ? void 0 : actionGroup.iconClass);
  };
  const getActionName = actionTypeId => {
    const actionConnector = actionConnectors.find(connector => connector.id === actionTypeId);
    return actionConnector === null || actionConnector === void 0 ? void 0 : actionConnector.name;
  };
  if (isLoadingActionConnectors) return /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
    size: "s"
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "none"
  }, ruleActions.map((action, index) => {
    var _getActionIconClass;
    const {
      actionTypeId,
      id
    } = action;
    const actionName = getActionName(id);
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      key: index
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      alignItems: "center",
      gutterSize: "s",
      component: "span"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      size: "m",
      type: (_getActionIconClass = getActionIconClass(actionTypeId)) !== null && _getActionIconClass !== void 0 ? _getActionIconClass : 'apps'
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      "data-test-subj": `actionConnectorName-${index}-${actionName || actionTypeId}`,
      size: "s"
    }, actionName), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      alignItems: "center",
      gutterSize: "xs",
      component: "span"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "xs"
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      size: "s",
      type: "bell"
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      "data-test-subj": `actionConnectorName-notify-text${index}-${actionName || actionTypeId}`,
      size: "xs"
    }, String(getNotifyText(action, actionTypeRegistry.get(actionTypeId).isSystemActionType))))))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "s"
    }));
  }));
}