"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.renderApp = exports.App = void 0;
var _react = _interopRequireWildcard(require("react"));
var _sharedUxRouter = require("@kbn/shared-ux-router");
var _reactDom = require("react-dom");
var _reactKibanaContextRender = require("@kbn/react-kibana-context-render");
var _suspended_component_with_props = require("./lib/suspended_component_with_props");
var _data_apis = require("../common/lib/data_apis");
var _kibana = require("../common/lib/kibana");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const StackAlertsPage = /*#__PURE__*/(0, _react.lazy)(() => Promise.resolve().then(() => _interopRequireWildcard(require('./sections/alerts_page'))));
const renderApp = deps => {
  const {
    element
  } = deps;
  (0, _reactDom.render)(/*#__PURE__*/_react.default.createElement(App, {
    deps: deps
  }), element);
  return () => {
    (0, _reactDom.unmountComponentAtNode)(element);
  };
};
exports.renderApp = renderApp;
const App = ({
  deps
}) => {
  const {
    dataViews
  } = deps;
  (0, _data_apis.setDataViewsService)(dataViews);
  return /*#__PURE__*/_react.default.createElement(_reactKibanaContextRender.KibanaRenderContextProvider, deps, /*#__PURE__*/_react.default.createElement(_kibana.KibanaContextProvider, {
    services: {
      ...deps
    }
  }, /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Router, {
    history: deps.history
  }, /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Routes, null, /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: `/`,
    component: (0, _suspended_component_with_props.suspendedComponentWithProps)(StackAlertsPage, 'xl')
  })))));
};
exports.App = App;