"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.routeHandlerFactory = void 0;
var _transform_api_key = require("../../../../common/utils/transform_api_key");
var _error_utils = require("../../utils/error_utils");
var _reauthorize_and_start_transforms = require("./reauthorize_and_start_transforms");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const routeHandlerFactory = routeDependencies => async (ctx, req, res) => {
  const {
    getCoreStart,
    getSecurity
  } = routeDependencies;
  const coreStart = await getCoreStart();
  const securityStart = await getSecurity();
  try {
    const transformsInfo = req.body;
    const {
      elasticsearch
    } = coreStart;
    const esClient = elasticsearch.client.asScoped(req).asCurrentUser;
    let apiKeyWithCurrentUserPermission;

    // If security is not enabled or available, user should not have the need to reauthorize
    // in that case, start anyway
    if (securityStart) {
      apiKeyWithCurrentUserPermission = await securityStart.authc.apiKeys.grantAsInternalUser(req, {
        name: `auto-generated-transform-api-key`,
        role_descriptors: {}
      });
    }
    const secondaryAuth = (0, _transform_api_key.generateTransformSecondaryAuthHeaders)(apiKeyWithCurrentUserPermission);
    const authorizedTransforms = await (0, _reauthorize_and_start_transforms.reauthorizeAndStartTransforms)(transformsInfo, esClient, {
      ...(secondaryAuth ? secondaryAuth : {})
    });
    return res.ok({
      body: authorizedTransforms
    });
  } catch (e) {
    return res.customError((0, _error_utils.wrapError)((0, _error_utils.wrapEsError)(e)));
  }
};
exports.routeHandlerFactory = routeHandlerFactory;