"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TransformTaskStateBadge = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _constants = require("../../../../../../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// reflects https://github.com/elastic/elasticsearch/blob/master/x-pack/plugin/core/src/main/java/org/elasticsearch/xpack/core/transform/transforms/TransformStats.java#L250
const STATE_COLOR = {
  aborting: 'warning',
  failed: 'danger',
  indexing: 'primary',
  started: 'primary',
  stopped: 'hollow',
  stopping: 'hollow',
  waiting: 'hollow'
};
const TransformTaskStateBadge = ({
  state,
  reason
}) => {
  const color = STATE_COLOR[state];
  if (state === _constants.TRANSFORM_STATE.FAILED && reason !== undefined) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      content: reason
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
      className: "transform__TaskStateBadge",
      color: color
    }, state));
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    className: "transform__TaskStateBadge",
    color: color
  }, state);
};
exports.TransformTaskStateBadge = TransformTaskStateBadge;