"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.setFormSection = exports.setFormField = exports.setApiError = exports.initialize = void 0;
var _get_default_state = require("./get_default_state");
var _validators = require("./validators");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function isFormFieldOptional(state, field) {
  const formField = state.formFields[field];
  let isOptional = formField.isOptional;
  if (formField.section) {
    const section = state.formSections[formField.section];
    if (section.enabled && formField.isOptionalInSection === false) {
      isOptional = false;
    }
  }
  return isOptional;
}
function getFormFieldErrorMessages(value, isOptional, validatorName) {
  return isOptional && typeof value === 'string' && value.length === 0 ? [] : _validators.validators[validatorName](value, isOptional);
}
const initialize = (_, action) => (0, _get_default_state.getDefaultState)(action.payload.config);
exports.initialize = initialize;
const setApiError = (state, action) => {
  state.apiErrorMessage = action.payload;
};
exports.setApiError = setApiError;
const setFormField = (state, action) => {
  const formField = state.formFields[action.payload.field];
  const isOptional = isFormFieldOptional(state, action.payload.field);
  formField.errorMessages = getFormFieldErrorMessages(action.payload.value, isOptional, formField.validator);
  formField.value = action.payload.value;
};
exports.setFormField = setFormField;
const setFormSection = (state, action) => {
  state.formSections[action.payload.section].enabled = action.payload.enabled;

  // After a section change we re-evaluate all form fields, since optionality
  // of a field could change if a section got toggled.
  Object.entries(state.formFields).forEach(([formFieldName, formField]) => {
    const isOptional = isFormFieldOptional(state, formFieldName);
    formField.errorMessages = getFormFieldErrorMessages(formField.value, isOptional, formField.validator);
  });
};
exports.setFormSection = setFormSection;