"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getAggFormConfig = getAggFormConfig;
var _terms_agg = require("./terms_agg");
var _percentiles_agg = require("./percentiles_agg");
var _pivot_aggs = require("../../../../../../../common/types/pivot_aggs");
var _config = require("./filter_agg/config");
var _top_metrics_agg = require("./top_metrics_agg");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Gets form configuration for provided aggregation type.
 */
function getAggFormConfig(agg, commonConfig) {
  switch (agg) {
    case _pivot_aggs.PIVOT_SUPPORTED_AGGS.FILTER:
      return (0, _config.getFilterAggConfig)(commonConfig);
    case _pivot_aggs.PIVOT_SUPPORTED_AGGS.TOP_METRICS:
      return (0, _top_metrics_agg.getTopMetricsAggConfig)(commonConfig);
    case _pivot_aggs.PIVOT_SUPPORTED_AGGS.PERCENTILES:
      return (0, _percentiles_agg.getPercentilesAggConfig)(commonConfig);
    case _pivot_aggs.PIVOT_SUPPORTED_AGGS.TERMS:
      return (0, _terms_agg.getTermsAggConfig)(commonConfig);
    default:
      return commonConfig;
  }
}