"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.GroupByLabelSummary = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _common = require("../../../../common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const GroupByLabelSummary = ({
  item,
  optionsDataId
}) => {
  let interval;
  if ((0, _common.isGroupByDateHistogram)(item)) {
    interval = item.calendar_interval;
  } else if ((0, _common.isGroupByHistogram)(item)) {
    interval = item.interval;
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "s",
    responsive: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    className: "transform__GroupByLabel--text"
  }, /*#__PURE__*/_react.default.createElement("span", {
    className: "eui-textTruncate"
  }, optionsDataId)), interval !== undefined && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    className: "transform__GroupByLabel--text transform__GroupByLabel--interval"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTextColor, {
    color: "subdued",
    className: "eui-textTruncate"
  }, interval)));
};
exports.GroupByLabelSummary = GroupByLabelSummary;