"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SwitchModal = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const modalTitle = _i18n.i18n.translate('xpack.transform.stepDefineForm.runtimeEditorSwitchModalTitle', {
  defaultMessage: 'Edits will be lost'
});
const cancelButtonText = _i18n.i18n.translate('xpack.transform.stepDefineForm.runtimeEditorSwitchModalCancelButtonText', {
  defaultMessage: 'Cancel'
});
const applyChangesText = _i18n.i18n.translate('xpack.transform.stepDefineForm.runtimeEditorSwitchModalConfirmButtonText', {
  defaultMessage: 'Close editor'
});
const modalMessage = _i18n.i18n.translate('xpack.transform.stepDefineForm.runtimeEditorSwitchModalBodyText', {
  defaultMessage: `The changes in the advanced editor haven't been applied yet. By closing the editor you will lose your edits.`
});
const SwitchModal = ({
  onCancel,
  onConfirm
}) => /*#__PURE__*/_react.default.createElement(_eui.EuiConfirmModal, {
  title: modalTitle,
  onCancel: onCancel,
  onConfirm: onConfirm,
  cancelButtonText: cancelButtonText,
  confirmButtonText: applyChangesText,
  buttonColor: "danger",
  defaultFocusedButton: "confirm"
}, /*#__PURE__*/_react.default.createElement("p", null, modalMessage));
exports.SwitchModal = SwitchModal;