"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useUpdateTransform = void 0;
var _reactQuery = require("@tanstack/react-query");
var _constants = require("../../../common/constants");
var _app_dependencies = require("../app_dependencies");
var _use_refresh_transform_list = require("./use_refresh_transform_list");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useUpdateTransform = (transformId, transformConfig) => {
  const {
    http
  } = (0, _app_dependencies.useAppDependencies)();
  const refreshTransformList = (0, _use_refresh_transform_list.useRefreshTransformList)();
  const mutation = (0, _reactQuery.useMutation)({
    mutationFn: () => http.post((0, _constants.addInternalBasePath)(`transforms/${transformId}/_update`), {
      body: JSON.stringify(transformConfig),
      version: '1'
    }),
    onSuccess: () => refreshTransformList()
  });
  return mutation.mutate;
};
exports.useUpdateTransform = useUpdateTransform;