"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TRANSFORM_ERROR_TYPE = void 0;
exports.isTransformIdValid = isTransformIdValid;
exports.overrideTransformForCloning = void 0;
var _lodash = require("lodash");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// Via https://github.com/elastic/elasticsearch/blob/master/x-pack/plugin/core/src/main/java/org/elasticsearch/xpack/core/transform/utils/TransformStrings.java#L24
// Matches a string that contains lowercase characters, digits, hyphens, underscores or dots.
// The string may start and end only in characters or digits.
// Note that '.' is allowed but not documented.
function isTransformIdValid(transformId) {
  return /^[a-z0-9](?:[a-z0-9_\-\.]*[a-z0-9])?$/g.test(transformId);
}
const TRANSFORM_ERROR_TYPE = exports.TRANSFORM_ERROR_TYPE = {
  DANGLING_TASK: 'dangling_task'
};
const overrideTransformForCloning = originalConfig => {
  var _clonedConfig$_meta;
  // 'Managed' means job is preconfigured and deployed by other solutions
  // we should not clone this setting
  const clonedConfig = (0, _lodash.cloneDeep)(originalConfig);
  (_clonedConfig$_meta = clonedConfig._meta) === null || _clonedConfig$_meta === void 0 ? true : delete _clonedConfig$_meta.managed;
  return clonedConfig;
};
exports.overrideTransformForCloning = overrideTransformForCloning;