"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getIndicatorQueryParams = void 0;
var _esQuery = require("@kbn/es-query");
var _common = require("../../../constants/common");
var _indicator = require("../../../../common/types/indicator");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const TIMESTAMP_FIELD = _indicator.RawIndicatorFieldId.TimeStamp;

/**
 * Prepare shared `query` fields used within indicator search request
 */
const getIndicatorQueryParams = ({
  filters,
  filterQuery,
  timeRange
}) => {
  return {
    query: (0, _esQuery.buildEsQuery)(undefined, [{
      query: _common.THREAT_QUERY_BASE,
      language: 'kuery'
    }, {
      query: filterQuery.query,
      language: 'kuery'
    }], [...filters, {
      query: {
        range: {
          [TIMESTAMP_FIELD]: {
            gte: timeRange === null || timeRange === void 0 ? void 0 : timeRange.from,
            lte: timeRange === null || timeRange === void 0 ? void 0 : timeRange.to
          }
        }
      },
      meta: {}
    }])
  };
};
exports.getIndicatorQueryParams = getIndicatorQueryParams;