"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.IndicatorsFilters = void 0;
var _react = _interopRequireWildcard(require("react"));
var _use_kibana = require("../../../hooks/use_kibana");
var _use_security_context = require("../../../hooks/use_security_context");
var _use_filters_context = require("../hooks/use_filters_context");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Container used to wrap components and share the {@link FilterManager} through React context.
 */
const IndicatorsFilters = ({
  children
}) => {
  const securityContext = (0, _use_security_context.useSecurityContext)();
  const {
    services: {
      data: {
        query: {
          filterManager
        }
      }
    }
  } = (0, _use_kibana.useKibana)();
  const globalFilters = securityContext.useFilters();
  const globalQuery = securityContext.useQuery();
  const globalTimeRange = securityContext.useGlobalTime();
  const contextValue = (0, _react.useMemo)(() => ({
    timeRange: globalTimeRange,
    filters: globalFilters,
    filterQuery: globalQuery,
    filterManager
  }), [globalFilters, globalQuery, globalTimeRange, filterManager]);
  return /*#__PURE__*/_react.default.createElement(_use_filters_context.IndicatorsFiltersContext.Provider, {
    value: contextValue
  }, children);
};
exports.IndicatorsFilters = IndicatorsFilters;