"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createConfigurationAggregator = createConfigurationAggregator;
var _rxjs = require("rxjs");
var _lodash = require("lodash");
var _config = require("../config");
var _task_pool = require("../task_pool");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const CONFIG_FIELDS_TO_EXPOSE = ['request_capacity', 'monitored_aggregated_stats_refresh_rate', 'monitored_stats_running_average_window', 'monitored_task_execution_thresholds'];
function createConfigurationAggregator(config, startingCapacity, taskPollingLifecycle) {
  var _config$claim_strateg;
  const capacity$ = taskPollingLifecycle ? taskPollingLifecycle.capacityConfiguration$.pipe((0, _rxjs.startWith)(startingCapacity), (0, _rxjs.map)(capacity => ({
    capacity: {
      config: capacity,
      as_workers: (0, _task_pool.getCapacityInWorkers)(capacity),
      as_cost: (0, _task_pool.getCapacityInCost)(capacity)
    }
  }))) : (0, _rxjs.of)({
    capacity: {
      config: startingCapacity,
      as_workers: (0, _task_pool.getCapacityInWorkers)(startingCapacity),
      as_cost: (0, _task_pool.getCapacityInCost)(startingCapacity)
    }
  });
  return (0, _rxjs.combineLatest)([(0, _rxjs.of)((0, _lodash.pick)(config, ...CONFIG_FIELDS_TO_EXPOSE)), (0, _rxjs.of)({
    claim_strategy: (_config$claim_strateg = config.claim_strategy) !== null && _config$claim_strateg !== void 0 ? _config$claim_strateg : _config.CLAIM_STRATEGY_UPDATE_BY_QUERY
  }), (0, _rxjs.of)({
    poll_interval: config.poll_interval
  }), capacity$]).pipe((0, _rxjs.map)(configurations => ({
    key: 'configuration',
    value: (0, _lodash.merge)({}, ...configurations)
  })));
}