"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerSyntheticsSavedObjects = void 0;
var _synthetics_monitor_config = require("./synthetics_monitor/synthetics_monitor_config");
var _synthetics_settings = require("./synthetics_settings");
var _synthetics_param = require("./synthetics_param");
var _private_locations = require("./private_locations");
var _legacy_synthetics_monitor = require("./synthetics_monitor/legacy_synthetics_monitor");
var _service_api_key = require("./service_api_key");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const registerSyntheticsSavedObjects = (savedObjectsService, encryptedSavedObjects) => {
  savedObjectsService.registerType(_private_locations.LEGACY_PRIVATE_LOCATIONS_SAVED_OBJECT_TYPE);
  savedObjectsService.registerType(_private_locations.PRIVATE_LOCATION_SAVED_OBJECT_TYPE);
  savedObjectsService.registerType(_synthetics_settings.syntheticsSettings);

  // legacy synthetics monitor saved object type which is single namespace
  savedObjectsService.registerType((0, _legacy_synthetics_monitor.getLegacySyntheticsMonitorSavedObjectType)(encryptedSavedObjects));
  encryptedSavedObjects.registerType(_legacy_synthetics_monitor.LEGACY_SYNTHETICS_MONITOR_ENCRYPTED_TYPE_SINGLE);

  // synthetics monitor config saved object type which supports multiple namespace
  savedObjectsService.registerType((0, _synthetics_monitor_config.getSyntheticsMonitorConfigSavedObjectType)());
  encryptedSavedObjects.registerType(_synthetics_monitor_config.SYNTHETICS_MONITOR_ENCRYPTED_TYPE);

  // service api key saved object type
  savedObjectsService.registerType(_service_api_key.syntheticsServiceApiKey);
  encryptedSavedObjects.registerType({
    type: _service_api_key.syntheticsServiceApiKey.name,
    attributesToEncrypt: new Set(['apiKey']),
    attributesToIncludeInAAD: new Set(['id', 'name'])
  });

  // global params saved object type
  savedObjectsService.registerType(_synthetics_param.syntheticsParamSavedObjectType);
  encryptedSavedObjects.registerType(_synthetics_param.SYNTHETICS_PARAMS_SECRET_ENCRYPTED_TYPE);
};
exports.registerSyntheticsSavedObjects = registerSyntheticsSavedObjects;