"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useViewButtons = void 0;
var _react = require("react");
var _reactRedux = require("react-redux");
var _useLocalStorage = _interopRequireDefault(require("react-use/lib/useLocalStorage"));
var _state = require("../../../../../../state");
var _hooks = require("../../../../../../hooks");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useViewButtons = () => {
  const isInitialMount = (0, _react.useRef)(true);
  const {
    view
  } = (0, _reactRedux.useSelector)(_state.selectOverviewState);
  const [urlParams, updateUrlParams] = (0, _hooks.useUrlParams)();
  const {
    view: urlView
  } = urlParams();
  const [localStorageView, setLocalStorageView] = (0, _useLocalStorage.default)('synthetics.overviewView', urlView || view);
  const dispatch = (0, _reactRedux.useDispatch)();
  if (isInitialMount.current) {
    // When the component mounts, check if there is a view in the URL first
    if (urlView) {
      dispatch((0, _state.setOverviewViewAction)(urlView));
    } // If there is no view in the URL, check if there is a view in local storage that is not the default view
    else if (localStorageView && localStorageView !== _state.DEFAULT_OVERVIEW_VIEW) {
      dispatch((0, _state.setOverviewViewAction)(localStorageView));
      updateUrlParams({
        view: localStorageView
      });
    }
    isInitialMount.current = false;
  }
  const onChangeView = id => {
    if (!(0, _state.isOverviewView)(id)) {
      throw new Error(`Invalid view: ${id}, this should never happen`);
    }
    dispatch((0, _state.setOverviewViewAction)(id));
    updateUrlParams({
      view: id === _state.DEFAULT_OVERVIEW_VIEW ? undefined : id
    });
    setLocalStorageView(id);
  };
  return {
    view,
    onChangeView
  };
};
exports.useViewButtons = useViewButtons;