"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.buildEsqlSearchRequest = void 0;
var _common = require("../common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const buildEsqlSearchRequest = ({
  query,
  timestampField,
  from,
  to,
  previousOriginalDocumentIds
}) => {
  const sanitizedDocumentIds = previousOriginalDocumentIds.filter(id => id != null);
  const rangeFilter = {
    range: {
      [timestampField]: {
        lte: to,
        gte: from,
        format: 'strict_date_optional_time'
      }
    }
  };
  const requestFilter = [rangeFilter];
  return {
    // Make sure query includes `METADATA _id, _source`
    query: `${query} | limit ${_common.MAX_ALERTS_PER_EXECUTION}`,
    filter: {
      bool: {
        must_not: sanitizedDocumentIds.length > 0 ? [{
          terms: {
            _id: sanitizedDocumentIds
          }
        }] : [],
        filter: requestFilter
      }
    }
  };
};
exports.buildEsqlSearchRequest = buildEsqlSearchRequest;