"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.STREAMS_UI_PRIVILEGES = exports.STREAMS_TIERED_SIGNIFICANT_EVENT_FEATURE = exports.STREAMS_TIERED_ML_FEATURE = exports.STREAMS_TIERED_FEATURES = exports.STREAMS_TIERED_AI_FEATURE = exports.STREAMS_RULE_REGISTRATION_CONTEXT = exports.STREAMS_PRODUCER = exports.STREAMS_FEATURE_ID = exports.STREAMS_CONSUMER = exports.STREAMS_API_PRIVILEGES = exports.ASSET_VERSION = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ASSET_VERSION = exports.ASSET_VERSION = 1;
const STREAMS_FEATURE_ID = exports.STREAMS_FEATURE_ID = 'streams';
const STREAMS_CONSUMER = exports.STREAMS_CONSUMER = 'streams';
const STREAMS_PRODUCER = exports.STREAMS_PRODUCER = 'streams';
const STREAMS_RULE_REGISTRATION_CONTEXT = exports.STREAMS_RULE_REGISTRATION_CONTEXT = 'streams';
const STREAMS_API_PRIVILEGES = exports.STREAMS_API_PRIVILEGES = {
  read: 'read_stream',
  manage: 'manage_stream'
};
const STREAMS_UI_PRIVILEGES = exports.STREAMS_UI_PRIVILEGES = {
  manage: 'manage',
  show: 'show'
};

/**
 * Tiered features
 */
const STREAMS_TIERED_ML_FEATURE = exports.STREAMS_TIERED_ML_FEATURE = {
  id: 'streams:ml-features',
  description: 'Enable ML features for streams',
  products: [{
    name: 'observability',
    tier: 'complete'
  }]
};
const STREAMS_TIERED_AI_FEATURE = exports.STREAMS_TIERED_AI_FEATURE = {
  id: 'streams:ai-features',
  description: 'Enable AI features for streams',
  products: [{
    name: 'observability',
    tier: 'complete'
  }]
};
const STREAMS_TIERED_SIGNIFICANT_EVENT_FEATURE = exports.STREAMS_TIERED_SIGNIFICANT_EVENT_FEATURE = {
  id: 'streams:significant-events',
  description: 'Enable significant events feature for streams',
  products: [{
    name: 'observability',
    tier: 'complete'
  }]
};
const STREAMS_TIERED_FEATURES = exports.STREAMS_TIERED_FEATURES = [STREAMS_TIERED_ML_FEATURE, STREAMS_TIERED_AI_FEATURE, STREAMS_TIERED_SIGNIFICANT_EVENT_FEATURE];