"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.NEVER_CONDITION = exports.EMPTY_EQUALS_CONDITION = exports.ALWAYS_CONDITION = void 0;
exports.alwaysToEmptyEquals = alwaysToEmptyEquals;
exports.emptyEqualsToAlways = emptyEqualsToAlways;
var _streamsSchema = require("@kbn/streams-schema");
var _lodash = require("lodash");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const EMPTY_EQUALS_CONDITION = exports.EMPTY_EQUALS_CONDITION = Object.freeze({
  field: '',
  operator: 'eq',
  value: ''
});
const ALWAYS_CONDITION = exports.ALWAYS_CONDITION = Object.freeze({
  always: {}
});
const NEVER_CONDITION = exports.NEVER_CONDITION = Object.freeze({
  never: {}
});
function alwaysToEmptyEquals(condition) {
  if ((0, _streamsSchema.isAlwaysCondition)(condition)) {
    return (0, _lodash.cloneDeep)(EMPTY_EQUALS_CONDITION);
  }
  return condition;
}
function emptyEqualsToAlways(condition) {
  if ((0, _lodash.isEqual)(condition, EMPTY_EQUALS_CONDITION)) {
    return ALWAYS_CONDITION;
  }
  return condition;
}