"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StreamsTelemetryService = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _events = require("./events");
var _client = require("./client");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class StreamsTelemetryService {
  constructor() {
    (0, _defineProperty2.default)(this, "analytics", void 0);
  }
  setup(analytics) {
    this.analytics = analytics;
    this.analytics.registerEventType(_events.streamsAssetCountEventType);
    this.analytics.registerEventType(_events.streamsAssetClickEventType);
    this.analytics.registerEventType(_events.streamsAIGrokSuggestionLatencyEventType);
    this.analytics.registerEventType(_events.streamsAIGrokSuggestionAcceptedEventType);
  }
  getClient() {
    if (!this.analytics) {
      throw new Error('Analytics service is not available.');
    }
    return new _client.StreamsTelemetryClient(this.analytics);
  }
}
exports.StreamsTelemetryService = StreamsTelemetryService;