"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CurrentStreamEntry = CurrentStreamEntry;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _streamsSchema = require("@kbn/streams-schema");
var _react = _interopRequireDefault(require("react"));
var _use_streams_app_router = require("../../../hooks/use_streams_app_router");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function CurrentStreamEntry({
  definition
}) {
  const router = (0, _use_streams_app_router.useStreamsAppRouter)();
  const breadcrumbs = (0, _streamsSchema.getAncestorsAndSelf)(definition.stream.name).map(parentId => {
    const isBreadcrumbsTail = parentId === definition.stream.name;
    return {
      text: parentId,
      href: isBreadcrumbsTail ? undefined : router.link('/{key}/management/{tab}', {
        path: {
          key: parentId,
          tab: 'route'
        }
      })
    };
  });
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, !(0, _streamsSchema.isRoot)(definition.stream.name) && /*#__PURE__*/_react.default.createElement(_eui.EuiBreadcrumbs, {
    breadcrumbs: breadcrumbs,
    truncate: false
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasShadow: false,
    hasBorder: true,
    paddingSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, definition.stream.name), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs",
    color: "subdued"
  }, _i18n.i18n.translate('xpack.streams.streamDetailRouting.currentStream', {
    defaultMessage: 'Current stream'
  })))));
}