"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.selectDraftProcessor = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Selects the processor marked as the draft processor.
 */
const selectDraftProcessor = context => {
  const draft = context.processorsRefs.find(p => p.getSnapshot().matches('draft'));
  return {
    processor: draft === null || draft === void 0 ? void 0 : draft.getSnapshot().context.processor,
    resources: draft === null || draft === void 0 ? void 0 : draft.getSnapshot().context.resources
  };
};
exports.selectDraftProcessor = selectDraftProcessor;