"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RootStreamEmptyPrompt = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _asset_image = require("../../asset_image");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const RootStreamEmptyPrompt = () => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
    titleSize: "xs",
    icon: /*#__PURE__*/_react.default.createElement(_asset_image.AssetImage, {
      type: "processorsCannotBeAddedToRootStreams"
    }),
    title: /*#__PURE__*/_react.default.createElement("h2", null, _i18n.i18n.translate('xpack.streams.streamDetailView.managementTab.rootStreamEmptyPrompt.title', {
      defaultMessage: 'Processing data is not allowed for root streams.'
    })),
    body: /*#__PURE__*/_react.default.createElement("p", null, _i18n.i18n.translate('xpack.streams.streamDetailView.managementTab.rootStreamEmptyPrompt.body', {
      defaultMessage: 'Root streams are selectively immutable and cannot be enriched with processors. To enrich data, reroute a new child stream and add processors to it.'
    }))
  });
};
exports.RootStreamEmptyPrompt = RootStreamEmptyPrompt;