"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getConnectorType = getConnectorType;
var _types = require("@kbn/actions-plugin/server/sub_action_framework/types");
var _common = require("@kbn/actions-plugin/common");
var _server = require("@kbn/actions-plugin/server");
var _constants = require("../../../common/xsoar/constants");
var _schema = require("../../../common/xsoar/schema");
var _xsoar = require("./xsoar");
var _render = require("./render");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function getConnectorType() {
  return {
    id: _constants.XSOAR_CONNECTOR_ID,
    minimumLicenseRequired: 'platinum',
    name: _constants.XSOAR_TITLE,
    getService: params => new _xsoar.XSOARConnector(params),
    supportedFeatureIds: [_common.SecurityConnectorFeatureId],
    schema: {
      config: _schema.ConfigSchema,
      secrets: _schema.SecretsSchema
    },
    renderParameterTemplates: _render.renderParameterTemplates,
    validators: [{
      type: _types.ValidatorType.CONFIG,
      validator: (0, _server.urlAllowListValidator)('url')
    }]
  };
}