"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.addSeverityAndEventTypeInBody = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const addSeverityAndEventTypeInBody = (bodyString, severity, eventType) => {
  let bodyObj = bodyString;
  try {
    bodyObj = JSON.parse(bodyString);
  } catch {
    // do nothing
  }
  return JSON.stringify({
    hits: {
      hits: {
        _source: {
          rawData: bodyObj,
          'event.type': eventType,
          'kibana.alert.severity': severity
        }
      }
    }
  });
};
exports.addSeverityAndEventTypeInBody = addSeverityAndEventTypeInBody;