"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.isPartialCloseAlertSchema = void 0;
var rt = _interopRequireWildcard(require("io-ts"));
var _schema_utils = require("./schema_utils");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * This schema must match the CloseAlertParamsSchema in x-pack/platform/plugins/shared/stack_connectors/server/connector_types/stack/opsgenie/schema.ts
 * except that it makes all fields partial.
 */
const CloseAlertSchema = rt.exact(rt.partial({
  alias: rt.string,
  user: rt.string,
  source: rt.string,
  note: rt.string
}));
const isPartialCloseAlertSchema = data => {
  try {
    (0, _schema_utils.decodeSchema)(CloseAlertSchema, data);
    return true;
  } catch (error) {
    return false;
  }
};
exports.isPartialCloseAlertSchema = isPartialCloseAlertSchema;