"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SpaceCard = void 0;
require("./space_card.scss");
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _common = require("../../../common");
var _space_avatar = require("../../space_avatar");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// No need to wrap LazySpaceAvatar in an error boundary, because it is one of the first chunks loaded when opening Kibana.
const LazySpaceAvatar = /*#__PURE__*/(0, _react.lazy)(() => (0, _space_avatar.getSpaceAvatarComponent)().then(component => ({
  default: component
})));
const SpaceCard = props => {
  const {
    serverBasePath,
    space
  } = props;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiCard, {
    className: "spaceCard",
    "data-test-subj": `space-card-${space.id}`,
    icon: renderSpaceAvatar(space),
    title: space.name,
    description: renderSpaceDescription(space),
    href: (0, _common.addSpaceIdToPath)(serverBasePath, space.id, _common.ENTER_SPACE_PATH)
  });
};
exports.SpaceCard = SpaceCard;
function renderSpaceAvatar(space) {
  // not announcing space name here because the title of the EuiCard that the SpaceAvatar lives in is already
  // announcing it. See https://github.com/elastic/kibana/issues/27748
  return /*#__PURE__*/_react.default.createElement(_react.Suspense, {
    fallback: /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
      size: "xxl"
    })
  }, /*#__PURE__*/_react.default.createElement(LazySpaceAvatar, {
    space: space,
    size: 'l',
    announceSpaceName: false
  }));
}
function renderSpaceDescription(space) {
  let description = space.description || '';
  const needsTruncation = description.length > 120;
  if (needsTruncation) {
    description = description.substr(0, 120) + '…';
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiTextColor, {
    color: "subdued",
    title: description,
    className: "eui-textBreakWord"
  }, description);
}