"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createSpacesFeatureCatalogueEntry = void 0;
var _i18n = require("@kbn/i18n");
var _constants = require("./constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const createSpacesFeatureCatalogueEntry = () => {
  return {
    id: 'spaces',
    title: _i18n.i18n.translate('xpack.spaces.spacesTitle', {
      defaultMessage: 'Spaces'
    }),
    description: (0, _constants.getSpacesFeatureDescription)(),
    icon: 'spacesApp',
    path: '/app/management/kibana/spaces',
    showOnHomePage: false,
    category: 'admin'
  };
};
exports.createSpacesFeatureCatalogueEntry = createSpacesFeatureCatalogueEntry;