"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useShowSections = useShowSections;
var _react = require("react");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function useShowSections(isEditMode, isFormValidating, isIndicatorSectionValid, isObjectiveSectionValid) {
  const [showDescriptionSection, setShowDescriptionSection] = (0, _react.useState)(isEditMode);
  const [showObjectiveSection, setShowObjectiveSection] = (0, _react.useState)(isEditMode);
  (0, _react.useEffect)(() => {
    if (!isFormValidating && !showObjectiveSection && isIndicatorSectionValid) {
      setShowObjectiveSection(true);
    }
  }, [showObjectiveSection, isIndicatorSectionValid, isFormValidating]);
  (0, _react.useEffect)(() => {
    if (!isFormValidating && !showDescriptionSection && isIndicatorSectionValid && isObjectiveSectionValid) {
      setShowDescriptionSection(true);
    }
  }, [showDescriptionSection, isIndicatorSectionValid, isObjectiveSectionValid, isFormValidating]);
  return {
    showDescriptionSection,
    showObjectiveSection
  };
}