"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getLastDurationInUnit = getLastDurationInUnit;
var _i18n = require("@kbn/i18n");
var _moment = _interopRequireDefault(require("moment"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function getLastDurationInUnit(timeRange) {
  const duration = _moment.default.duration((0, _moment.default)(timeRange.to).diff(timeRange.from));
  const durationInSeconds = duration.asSeconds();
  const oneMinute = 60;
  if (durationInSeconds < oneMinute) {
    return _i18n.i18n.translate('xpack.slo.burnRateRule.alertDetailsAppSection.lastDurationInSeconds', {
      defaultMessage: 'Last {duration} seconds',
      values: {
        duration: Math.trunc(durationInSeconds)
      }
    });
  }
  const twoHours = 2 * 60 * 60;
  if (durationInSeconds < twoHours) {
    return _i18n.i18n.translate('xpack.slo.burnRateRule.alertDetailsAppSection.lastDurationInMinutes', {
      defaultMessage: 'Last {duration} minutes',
      values: {
        duration: Math.trunc(duration.asMinutes())
      }
    });
  }
  const twoDays = 2 * 24 * 60 * 60;
  if (durationInSeconds < twoDays) {
    return _i18n.i18n.translate('xpack.slo.burnRateRule.alertDetailsAppSection.lastDurationInHours', {
      defaultMessage: 'Last {duration} hours',
      values: {
        duration: Math.trunc(duration.asHours())
      }
    });
  }
  return _i18n.i18n.translate('xpack.slo.burnRateRule.alertDetailsAppSection.lastDurationInDays', {
    defaultMessage: 'Last {duration} days',
    values: {
      duration: Math.trunc(duration.asDays())
    }
  });
}